<?php
/**
 * Author: Dev Mxo <dev@agencemxo.com>, Stéphane Cloutier <stephane.cloutier@agencemxo.com>
 * License: MXO Copyright, exclusive usage.
 */

namespace MxoSoftunikPlugin\Admin\Site;

class SyncPage
{
    protected static $singleton;

    protected $initialized = false;

    protected function __construct()
    {
    }

    public static function singleton(){
        if(!isset(self::$singleton)){
            self::$singleton = new self();
        }

        return self::$singleton;
    }

    public static function initialize(){
        $singleton = self::singleton();
        $singleton->_initialize();
    }

    protected function _initialize(){
        if(!$this->initialized) {
            $this->initialized = true;

//            add_action('admin_bar_init', array($this, 'sync'));
            add_action('admin_menu', array($this, 'menu_init'));
            add_action("admin_post_nopriv_mxo_softunik_sync", array($this,'sync'));
            add_action("admin_post_mxo_softunik_sync", array($this,'sync'));
        }
    }

    public function sync()
    {
        if(!defined('WP_CLI')){
            define('WP_CLI','fake to include needed files');
        }
        if(!defined('WP_CLI_ABSPATH')){
            define('WP_CLI_ABSPATH',realpath(ABSPATH . '../wp-cli'));
        }
        require_once(WP_CLI_ABSPATH . '/vendor/autoload.php');

        $pluginDirectory = \MxoSoftunikPlugin::returnPath();

        require($pluginDirectory . '/wp-cli/commands/sync.php');

        $command = new \MxoSoftunikPlugin\Command\Sync(
            $commandBasename,
            new \MxoWPCLI\Configuration(
                $configurationRepository . '/commands/sync.php',
                array(
                    $configurationRepository . '/softunik.php'
                )
            )
        );
        $command->execute(array(),array());

        $location = $_SERVER['HTTP_REFERER'];
        wp_safe_redirect('https://prograin.staging.mxo.website/ca/wp-admin/edit.php?post_type=carrieres-prograin&page=mxo-softunik-sync');
        // wp_safe_redirect($form_data->submitted_fields->redirect_url);
        exit;
    }

    /**
     *
     */
    public function menu_init()
    {
        add_submenu_page('edit.php?post_type=carrieres-prograin', 'Synchronization Softunik/GlowInTheCLoud', 'Synchronization', 'manage_options', 'mxo-softunik-sync', array($this, 'menu_page_output'));
    }

    public function menu_page_output()
    { ?>

        <div class="wrap">
            <h1 class="wp-heading-inline">Synchronization Softunik/GlowInTheCLoud</h1>
            <div>
                <!-- a class="components-button is-primary" href='<?php echo admin_url('edit.php?post_type=carrieres-prograin&page=mxo-softunik-sync&sync=1'); ?>'>Synchronizer</a -->
                <form id="mxo-softunik-sync" method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>">
                    <input id="action" type="hidden" name="action" value="<?php echo 'mxo_softunik_sync'; ?>"/>
                    <button type="submit"><?php echo 'Synchronizer' ?></button>
                </form>
            </div>
        </div>
        <?php
    }
}