<?php
/**
 * Author: Dev Mxo <dev@agencemxo.com>, Stéphane Cloutier <stephane.cloutier@agencemxo.com>
 * License: MXO Copyright, exclusive usage.
 */

namespace MxoSoftunikPlugin\Command;

use WP_CLI;
use WP_User;
use Exception;
use DateTime;
use DateTimeZone;
use MxoWPCLI\Configuration;
use MxoSoftunikPlugin\APIHelper;

/**
 * Class Sync
 * @package MxoSoftunikPlugin\Command
 */
class Sync extends \MxoWPCLI\Command
{
    /** @var APIHelper */
    protected $APIHelper;

    /**
     * @param $args
     * @param $assoc_args
     * @throws Exception
     */
    public function execute($args, $assoc_args)
    {
        global $wpdb;

        $errorsCount = 0;

        $careersCreatedCount = 0;
        $careersCreatedWithoutErrorsCount = 0;

        $careersUpdatedCount = 0;
        $careersUpdatedWithoutErrorsCount = 0;

        $careerTranslationsCreatedCount = 0;
        $careerTranslationsCreatedWithoutErrorsCount = 0;

        $careerTranslationsUpdatedCount = 0;
        $careerTranslationsUpdatedWithoutErrorsCount = 0;

        $careersDeletedCount = 0;
        $careersDeletedWithoutErrorsCount = 0;

        $careerTranslationsDeletedCount = 0;
        $careerTranslationsDeletedWithoutErrorsCount = 0;

        try {
            $this->build();

            $this->log("Started at '{$this->startDateTimeFormatted}'.", $this->configuration->LOG_TYPE_RESULT);

            $APIHelper = $this->retrieveAPIHelper();

            if(is_multisite()){
                //// To update api connection infos.
                // update_site_option('softunik_api_id','APP-API-PROGRAIN');// ex: APP-API-SOMETHING
                // update_site_option('softunik_api_secret','AaVMV8BkUdzxcxK');// ex: HJG65asd897JDHG
                // update_site_option('softunik_api_code','10142');// ex: 10767
                // return;

                $siteIDs = get_sites(array(
                    'fields' => 'ids',
                ));

                foreach($siteIDs as $siteID){
                    // Making sure we're only treating the Eastern Canada site for the moment.
                    if(((int)$siteID) === 3){
                        try{
                            switch_to_blog($siteID);

//                            // To update config option for particular wordpress sites.
//                            if(((int)$siteID) === 3){
//                                update_option( 'softunik_config', json_encode((object)[
//                                    'locale_mapping' => (object)[
//                                        'softunik_locale' => 'fr',
//                                        'locale' => 'fr_CA',
//                                        'translations' => [
//                                            (object)[
//                                                'softunik_locale' => 'en',
//                                                'locale' => 'en_CA'
//                                            ]
//                                        ]
//                                    ],
//                                    'category_mapping' => [
//                                        //(object)[
//                                        //    'softunik_site_id' => 1,
//                                        //    'category_id' => 0,
//                                        //],
//                                        (object)[
//                                            'softunik_site_id' => 2,
//                                            'category_id' => 452,
//                                        ],
//                                        (object)[
//                                            'softunik_site_id' => 3,
//                                            'category_id' => 111,
//                                        ],
//                                        (object)[
//                                            'softunik_site_id' => 4,
//                                            'category_id' => 105,
//                                        ],
//                                        (object)[
//                                            'softunik_site_id' => 5,
//                                            'category_id' => 540,
//                                        ],
//                                    ],
//                                ]));
//                            }
//                            continue;

                            $this->log("\n####################################", $this->configuration->LOG_TYPE_DEBUG);

                            //$this->log("WordPress site id '{$siteID}'.", $this->configuration->LOG_TYPE_DEBUG);

                            // Making sur we have included application needed theme files.
                            // Not included by default in cli as these are included via init in functions.php for frontend.
                            $files = glob(get_stylesheet_directory() . "/app/content/*/*.php");
                            foreach ($files as $file) {
                                require_once($file);
                            }

                            $softunikConfig = get_option( 'softunik_config' );
                            if(empty($softunikConfig)){
                                // Skipping the site if it's not configured to sync with Softunik.
                                continue;
                            }

                            $softunikConfig = json_decode($softunikConfig);

                            if($softunikConfig === null){
                                throw new Exception("Error while decoding the Softunik stored config.");
                            }

                            //$this->log("Softunik config: " . preg_replace('#\n$#','',print_r($softunikConfig,true)), $this->configuration->LOG_TYPE_DEBUG);

                            if(!property_exists($softunikConfig,'locale_mapping')){
                                throw new Exception("A valid 'locale_mapping' property is required in Softunik stored config.");
                            }

                            if(!property_exists($softunikConfig,'category_mapping')){
                                throw new Exception("A valid 'category_mapping' property is required in Softunik stored config.");
                            }

                            $locales = array();
                            $translationMethodUsed = null;

                            // Figuring out if we are using translations and if so the method used for translations.
                            if(property_exists($softunikConfig->locale_mapping,'translations') && !empty($softunikConfig->locale_mapping->translations)){
                                if(function_exists('pll_languages_list')){
                                    $translationMethodUsed = 'polylang';
                                    $polylangSlugs = pll_languages_list(array(
                                        'fields' => 'slug',
                                    ));
                                    $polylangLocales = pll_languages_list(array(
                                        'fields' => 'locale',
                                    ));
                                    foreach($polylangSlugs as $key => $slug){
                                        $locales[$polylangLocales[$key]] = (object)array(
                                            'code2char' => substr($polylangLocales[$key],0,2),
                                            'slug' => $slug,
                                        );
                                    }
                                }
                            }

                            // Feeding a locale to the list if none were added.
                            if(empty($locales)){
                                $locale = get_locale();

                                $locales[$locale] = (object)array(
                                    'code2char' => substr($locale,0,2),
                                );
                            }

                            $this->log("Locales: " . preg_replace('#\n$#','',print_r($locales,true)), $this->configuration->LOG_TYPE_DEBUG);

                            if(!empty($softunikConfig->category_mapping)){

                                $mainLocale = $softunikConfig->locale_mapping->locale;
                                $mainCode2char = $locales[$mainLocale]->code2char;
                                $mainTranslationSlug = (property_exists($locales[$mainLocale],'slug')?$locales[$mainLocale]->slug:null);

                                $publicRequestDataIDs = [];

                                foreach($softunikConfig->category_mapping as $mainCategoryMap){
                                    try{
                                        $this->log("\n##################\n", $this->configuration->LOG_TYPE_DEBUG);
                                        $this->log("Softunik site id: " . $mainCategoryMap->softunik_site_id, $this->configuration->LOG_TYPE_DEBUG);

                                        if ( is_textdomain_loaded( 'mxo-softunik' ) ) {
                                            unload_textdomain( 'mxo-softunik' );
                                        }
                                        $textDomainLoaded = load_textdomain( 'mxo-softunik', path_join( \MxoSoftunikPlugin::returnPath(), sprintf( 'i18n/%s.mo', $mainLocale ) ) );

                                        $mainCategory = get_term_by('id', $mainCategoryMap->category_id,'carrieres-cat');

                                        if(empty($mainCategory)){
                                            throw new Exception("The main category '{$mainCategoryMap->category_id}' mapped must exist.");
                                        }

                                        //$this->log("Category: " . preg_replace('#\n$#','',print_r($mainCategory,true)), $this->configuration->LOG_TYPE_DEBUG);

                                        $mainCategoryLocale = null;

                                        // Setting main category translations if a translation method was identified.
                                        $mainCategoryTranslations = null;
                                        if($translationMethodUsed==='polylang'){
                                            $mainCategoryLocale = pll_get_term_language($mainCategory->term_id,'locale');
                                            $mainCategoryTranslations = pll_get_term_translations($mainCategory->term_id);

                                            // Excluding the main category.
                                            unset($mainCategoryTranslations[$locales[$mainCategoryLocale]->slug]);
                                        }

                                        // Setting a locale for the main category.
                                        if(!isset($mainCategoryLocale)){
                                            $mainCategoryLocale = get_locale();
                                        }

                                        if($mainCategoryLocale !== $mainLocale){
                                            throw new Exception("The main category '{$mainCategoryMap->category_id}' locale must be the same as the main locale.");
                                        }

                                        $this->log("Category locale: " . preg_replace('#\n$#','',print_r($mainCategoryLocale,true)), $this->configuration->LOG_TYPE_DEBUG);
                                        $this->log("Category translations: " . preg_replace('#\n$#','',print_r($mainCategoryTranslations,true)), $this->configuration->LOG_TYPE_DEBUG);

                                        // Sending Softunik API request for public data.
                                        $publicRequestsData = $APIHelper->returnPublicRequestsData(
                                            array(
                                                'siteid' => $mainCategoryMap->softunik_site_id,
                                                'orderby' => 'id',
                                                'order' => 'ASC',
                                            )
                                        );

                                        if(!empty($publicRequestsData)) {
                                            foreach ($publicRequestsData as $publicRequestData) {
                                                if ( is_textdomain_loaded( 'mxo-softunik' ) ) {
                                                    unload_textdomain( 'mxo-softunik' );
                                                }
                                                $textDomainLoaded = load_textdomain( 'mxo-softunik', path_join( \MxoSoftunikPlugin::returnPath(), sprintf( 'i18n/%s.mo', $mainLocale ) ) );

                                                $publicRequestDataIDs[] = $publicRequestData['id'];

                                                $mainPostID = null;

                                                $this->log("Softunik API request result: " . preg_replace('#\n$#','',print_r($publicRequestData,true)), $this->configuration->LOG_TYPE_DEBUG);

                                                $sql = "" .
                                                    "SELECT  " .
                                                    "    t_posts.ID as ID " .
                                                    "FROM {$wpdb->base_prefix}{$siteID}_posts t_posts " .
                                                    "INNER JOIN {$wpdb->base_prefix}{$siteID}_postmeta t_postmeta ON ( " .
                                                    "    t_postmeta.post_id=t_posts.ID " .
                                                    ") " .
                                                    "";
                                                if($translationMethodUsed==='polylang'){
                                                    // To only fetch the careers configured for the main locale.
                                                    $sql .= "" .
                                                        "INNER JOIN {$wpdb->base_prefix}{$siteID}_term_relationships t_term_relationships ON ( " .
                                                        "    t_term_relationships.object_id=t_posts.ID " .
                                                        ") " .
                                                        "INNER JOIN {$wpdb->base_prefix}{$siteID}_term_taxonomy t_term_taxonomy ON ( " .
                                                        "    t_term_taxonomy.term_taxonomy_id=t_term_relationships.term_taxonomy_id " .
                                                        ") " .
                                                        "";
                                                }
                                                $sql .= "" .
                                                    "WHERE " .
                                                    "    t_posts.post_type = 'carrieres-prograin' " .
                                                    "    AND t_postmeta.meta_key = 'softunik_public_request_id' " .
                                                    "    AND t_postmeta.meta_value = '{$publicRequestData['id']}' " .
                                                    "";
                                                if($translationMethodUsed==='polylang') {
                                                    // To only fetch the careers configured for the main locale.
                                                    $sql .= "" .
                                                        "    AND t_term_taxonomy.taxonomy='language' " .
                                                        "    AND t_term_taxonomy.description REGEXP '(\\{|;)s\\:" . strlen($mainLocale) . "\\:\"{$mainLocale}\";' " .
                                                        "";
                                                }
                                                $sql .= "" .
                                                    "LIMIT 1" .
                                                    "";

                                                $mainPostID = $wpdb->get_var($sql);

                                                if(!empty($mainPostID)){
                                                    // Updating found career if query returned a result.
                                                    ++$careersUpdatedCount;
                                                    $errorOnUpdate = false;

                                                    $this->log("Starting the update of career.", $this->configuration->LOG_TYPE_INFO | $this->configuration->LOG_TYPE_DEBUG);
                                                    $this->log(preg_replace('#\n$#','',print_r([
                                                        'id' => $mainPostID,
                                                        'site' => $siteID,
                                                        'locale' => $mainLocale,
                                                        'category id' => $mainCategory->term_id,
                                                        'Softunik public request id' => $publicRequestData['id'],
                                                        'Softunik site id' => $mainCategoryMap->softunik_site_id,
                                                    ],true)), $this->configuration->LOG_TYPE_INFO | $this->configuration->LOG_TYPE_DEBUG);

                                                    $title = null;
                                                    if(
                                                        isset($publicRequestData["{$mainCode2char}_title"])
                                                        && !empty(trim($publicRequestData["{$mainCode2char}_title"]))
                                                    ){
                                                        $title = $publicRequestData["{$mainCode2char}_title"];
                                                    }
                                                    //else{
                                                    //    // Picking first none empty title
                                                    //    $titleKey = null;
                                                    //    $titleKeys = preg_grep('#^.+?_title$#',array_keys($publicRequestData));
                                                    //    if(!empty($titleKeys)){
                                                    //        foreach($titleKeys as $t_titleKey){
                                                    //            if(!empty(trim($publicRequestData[$t_titleKey]))){
                                                    //                $titleKey = $t_titleKey;
                                                    //                break;
                                                    //            }
                                                    //        }
                                                    //    }
                                                    //    if(isset($titleKey)){
                                                    //        $title = $publicRequestData[$titleKey];
                                                    //    }
                                                    //}

                                                    if(empty($title)){
                                                        throw new Exception("The '{$mainCode2char}' title for Softunik public request '{$publicRequestData['id']}' from Softunik site '{$mainCategoryMap->softunik_site_id}' must exist and not be empty.");
                                                    }

                                                    //$this->log("Title is '{$title}'.", $this->configuration->LOG_TYPE_DEBUG);

                                                    $mainUpdateResult = wp_update_post(array(
                                                        'ID' => $mainPostID,
                                                        'post_title' => $title,
                                                        'post_name' => sanitize_title($title),
                                                    ));

                                                    if($mainUpdateResult) {
                                                        $this->log("Updated career post_title and post_name with success.", $this->configuration->LOG_TYPE_DEBUG);
                                                    }
                                                    else{
                                                        $errorOnUpdate = true;
                                                        ++$errorsCount;
                                                        $this->log("Error: Career post_title and post_name update failed.", $this->configuration->LOG_TYPE_ERROR | $this->configuration->LOG_TYPE_DEBUG);
                                                    }

                                                    $mainCategoryUpdateResult = wp_set_object_terms($mainPostID, $mainCategory->term_id, 'carrieres-cat', false);

                                                    if($mainCategoryUpdateResult) {
                                                        $this->log("Updated career category with success.", $this->configuration->LOG_TYPE_INFO | $this->configuration->LOG_TYPE_DEBUG);
                                                    }else{
                                                        $errorOnUpdate = true;
                                                        ++$errorsCount;
                                                        $this->log("Error: Career category update failed.", $this->configuration->LOG_TYPE_ERROR | $this->configuration->LOG_TYPE_DEBUG);
                                                    }

                                                    if(!function_exists('get_field')){
                                                        throw new Exception("All the career metas update failed because the 'get_field' function is needed.");
                                                    }

                                                    if(!function_exists('update_field')){
                                                        throw new Exception("All the career metas update failed because the 'update_field' function is needed.");
                                                    }

                                                    // softunik_public_request_id
                                                    // update_field('field_803aee254165043',$publicRequestData['id'],$mainPostID);

                                                    // horaire
                                                    $duration = $this->returnDurationFromPublicRequestData($publicRequestData,$mainCategoryMap->softunik_site_id,$mainCode2char);
                                                    if($duration === false){
                                                        $errorOnUpdate = true;
                                                        ++$errorsCount;
                                                    }
                                                    if(!$this->updateHoraireField($duration,$mainPostID)){
                                                        $errorOnUpdate = true;
                                                        ++$errorsCount;
                                                    }

                                                    // Getting job_types to update quart and statut fields
                                                    $jobTypes = $this->returnJobTypesFromPublicRequestData($publicRequestData,$mainCategoryMap->softunik_site_id,$mainCode2char);
                                                    if($jobTypes === false){
                                                        $errorOnUpdate = true;
                                                        ++$errorsCount;
                                                    }

                                                    // quart
                                                    if(!$this->updateQuartField($jobTypes,$mainPostID)){
                                                        $errorOnUpdate = true;
                                                        ++$errorsCount;
                                                    }

                                                    // statut
                                                    if(!$this->updateStatutField($jobTypes,$mainPostID)){
                                                        $errorOnUpdate = true;
                                                        ++$errorsCount;
                                                    }

                                                    // entree
                                                    $deliveryDate = $this->returnDeliveryDateFromPublicRequestData($publicRequestData,$mainCategoryMap->softunik_site_id,$mainCode2char);
                                                    if($deliveryDate === false){
                                                        $errorOnUpdate = true;
                                                        ++$errorsCount;
                                                    }
                                                    if(!$this->updateEntreeField($deliveryDate,$mainPostID)){
                                                        $errorOnUpdate = true;
                                                        ++$errorsCount;
                                                    }

                                                    // description
                                                    $description = $this->returnDescriptionFromPublicRequestData($publicRequestData,$mainCategoryMap->softunik_site_id,$mainCode2char);
                                                    if($description === false){
                                                        $errorOnUpdate = true;
                                                        ++$errorsCount;
                                                    }
                                                    if(!$this->updateDescriptionField($description,$mainPostID)){
                                                        $errorOnUpdate = true;
                                                        ++$errorsCount;
                                                    }

                                                    // competences
                                                    $assets = $this->returnAssetsFromPublicRequestData($publicRequestData,$mainCategoryMap->softunik_site_id,$mainCode2char);
                                                    if($assets === false){
                                                        $errorOnUpdate = true;
                                                        ++$errorsCount;
                                                    }
                                                    if(!$this->updateCompetencesField($assets,$mainPostID)){
                                                        $errorOnUpdate = true;
                                                        ++$errorsCount;
                                                    }

                                                    // exigences
                                                    $skills = $this->returnSkillsFromPublicRequestData($publicRequestData,$mainCategoryMap->softunik_site_id,$mainCode2char);
                                                    if($skills === false){
                                                        $errorOnUpdate = true;
                                                        ++$errorsCount;
                                                    }
                                                    if(!$this->updateExigencesField($skills,$mainPostID)){
                                                        $errorOnUpdate = true;
                                                        ++$errorsCount;
                                                    }

                                                    // niveau_scolaire
                                                    //update_field('field_5c5b412d82120', 'High School/Secondaire', $mainPostID);
                                                    //update_field('niveau_scolaire', 'High School/Secondaire', $mainPostID);

                                                    // diplome
                                                    $diplomas = $this->returnDiplomasFromPublicRequestData($publicRequestData);
                                                    if($diplomas === false){
                                                        $errorOnUpdate = true;
                                                        ++$errorsCount;
                                                    }
                                                    if(!$this->updateDiplomeField($diplomas,$mainPostID)){
                                                        $errorOnUpdate = true;
                                                        ++$errorsCount;
                                                    }

                                                    // experiences
                                                    //update_field('field_5c5b413c82122', '1-2 years in factory/1-2 années en usine', $mainPostID);
                                                    //update_field('experiences', '1-2 years in factory/1-2 années en usine', $mainPostID);

                                                    // langues_ecrites
                                                    $writtenLanguages = $this->returnWrittenLanguagesFromPublicRequestData($publicRequestData);
                                                    if($writtenLanguages === false){
                                                        $errorOnUpdate = true;
                                                        ++$errorsCount;
                                                    }
                                                    if(!$this->updateLanguesEcritesField($writtenLanguages,$mainPostID)){
                                                        $errorOnUpdate = true;
                                                        ++$errorsCount;
                                                    }

                                                    // langues_parlees
                                                    $spokenLanguages = $this->returnSpokenLanguagesFromPublicRequestData($publicRequestData);
                                                    if($spokenLanguages === false){
                                                        $errorOnUpdate = true;
                                                        ++$errorsCount;
                                                    }
                                                    if(!$this->updateLanguesParleesField($spokenLanguages,$mainPostID)){
                                                        $errorOnUpdate = true;
                                                        ++$errorsCount;
                                                    }

                                                    if($translationMethodUsed==='polylang') {

                                                        $careerTranslations = pll_get_post_translations($mainPostID);

                                                        foreach($softunikConfig->locale_mapping->translations as $translationLocaleMap){
                                                            try{
                                                                $translationSlug = $locales[$translationLocaleMap->locale]->slug;
                                                                if (isset($mainCategoryTranslations[$translationSlug])) {
                                                                    $translationCategoryLocale = $translationLocaleMap->locale;
                                                                    $translationCategoryId = $mainCategoryTranslations[$locales[$translationCategoryLocale]->slug];

                                                                    $this->log("Translation category '{$translationCategoryId}'.", $this->configuration->LOG_TYPE_INFO | $this->configuration->LOG_TYPE_DEBUG);

                                                                    if(isset($careerTranslations[$translationSlug])){
                                                                        // Updating found career translation.
                                                                        ++$careerTranslationsUpdatedCount;
                                                                        $errorOnTranslationUpdate = false;

                                                                        $translationPostID = $careerTranslations[$translationSlug];

                                                                        $translationLocale = $translationLocaleMap->locale;
                                                                        $translationCode2char = $locales[$translationLocaleMap->locale]->code2char;

                                                                        if ( is_textdomain_loaded( 'mxo-softunik' ) ) {
                                                                            unload_textdomain( 'mxo-softunik' );
                                                                        }
                                                                        $textDomainLoaded = load_textdomain( 'mxo-softunik', path_join( \MxoSoftunikPlugin::returnPath(), sprintf( 'i18n/%s.mo', $translationLocale ) ) );

                                                                        $this->log("Starting the update of career translation.", $this->configuration->LOG_TYPE_INFO | $this->configuration->LOG_TYPE_DEBUG);
                                                                        try{
                                                                            $this->log(preg_replace('#\n$#','',print_r([
                                                                                'id' => $translationPostID,
                                                                                'locale' => $translationLocale,
                                                                                'category id' => $translationCategoryId,
                                                                            ],true)), $this->configuration->LOG_TYPE_INFO | $this->configuration->LOG_TYPE_DEBUG);

                                                                            $title = null;
                                                                            if(
                                                                                isset($publicRequestData["{$translationCode2char}_title"])
                                                                                && !empty(trim($publicRequestData["{$translationCode2char}_title"]))
                                                                            ){
                                                                                $title = $publicRequestData["{$translationCode2char}_title"];
                                                                            }
                                                                            //else{
                                                                            //    // Picking first none empty title
                                                                            //    $titleKey = null;
                                                                            //    $titleKeys = preg_grep('#^.+?_title$#',array_keys($publicRequestData));
                                                                            //    if(!empty($titleKeys)){
                                                                            //        foreach($titleKeys as $t_titleKey){
                                                                            //            if(!empty(trim($publicRequestData[$t_titleKey]))){
                                                                            //                $titleKey = $t_titleKey;
                                                                            //                break;
                                                                            //            }
                                                                            //        }
                                                                            //    }
                                                                            //    if(isset($titleKey)){
                                                                            //        $title = $publicRequestData[$titleKey];
                                                                            //    }
                                                                            //}

                                                                            if(empty($title)){
                                                                                throw new Exception("The '{$translationCode2char}' title for Softunik public request '{$publicRequestData['id']}' from Softunik site '{$mainCategoryMap->softunik_site_id}' must exist and not be empty.");
                                                                            }

                                                                            $this->log("Title is '{$title}'.", $this->configuration->LOG_TYPE_DEBUG);

                                                                            $translationUpdateResult = wp_update_post(array(
                                                                                'ID' => $translationPostID,
                                                                                'post_title' => $title,
                                                                                'post_name' => sanitize_title($title),
                                                                            ));

                                                                            if($translationUpdateResult) {
                                                                                $this->log("Updated career translation post_title and post_name with success.", $this->configuration->LOG_TYPE_DEBUG);
                                                                            }
                                                                            else{
                                                                                $errorOnTranslationUpdate = true;
                                                                                ++$errorsCount;
                                                                                $this->log("Error: Career translation post_title and post_name update failed.", $this->configuration->LOG_TYPE_ERROR | $this->configuration->LOG_TYPE_DEBUG);
                                                                            }

                                                                            $translationCategoryUpdateResult = wp_set_object_terms($translationPostID, $translationCategoryId, 'carrieres-cat', false);

                                                                            if($translationCategoryUpdateResult) {
                                                                                $this->log("Updated career translation category with success.", $this->configuration->LOG_TYPE_INFO | $this->configuration->LOG_TYPE_DEBUG);
                                                                            }else{
                                                                                $errorOnTranslationUpdate = true;
                                                                                ++$errorsCount;
                                                                                $this->log("Error: Career category translation update failed.", $this->configuration->LOG_TYPE_ERROR | $this->configuration->LOG_TYPE_DEBUG);
                                                                            }

                                                                            if(!function_exists('get_field')){
                                                                                throw new Exception("All the career translation metas update failed because the 'get_field' function is needed.");
                                                                            }

                                                                            if(!function_exists('update_field')){
                                                                                throw new Exception("All the career translation metas update failed because the 'update_field' function is needed.");
                                                                            }

                                                                            // softunik_public_request_id
                                                                            // update_field('field_803aee254165043',$publicRequestData['id'],$translationPostID);

                                                                            // horaire
                                                                            $duration = $this->returnDurationFromPublicRequestData($publicRequestData,$mainCategoryMap->softunik_site_id,$translationCode2char);
                                                                            if($duration === false){
                                                                                $errorOnTranslationUpdate = true;
                                                                                ++$errorsCount;
                                                                            }
                                                                            if(!$this->updateHoraireField($duration,$translationPostID)){
                                                                                $errorOnTranslationUpdate = true;
                                                                                ++$errorsCount;
                                                                            }

                                                                            // Getting job_types to update quart and statut fields
                                                                            //$jobTypes = $this->returnJobTypesFromPublicRequestData($publicRequestData,$mainCategoryMap->softunik_site_id,$translationCode2char);
                                                                            //if($jobTypes === false){
                                                                            //    $errorOnTranslationUpdate = true;
                                                                            //    ++$errorsCount;
                                                                            //}

                                                                            // quart
                                                                            if(!$this->updateQuartField($jobTypes,$translationPostID)){
                                                                                $errorOnTranslationUpdate = true;
                                                                                ++$errorsCount;
                                                                            }

                                                                            // statut
                                                                            if(!$this->updateStatutField($jobTypes,$translationPostID)){
                                                                                $errorOnTranslationUpdate = true;
                                                                                ++$errorsCount;
                                                                            }

                                                                            // entree
                                                                            $deliveryDate = $this->returnDeliveryDateFromPublicRequestData($publicRequestData,$mainCategoryMap->softunik_site_id,$translationCode2char);
                                                                            if($deliveryDate === false){
                                                                                $errorOnTranslationUpdate = true;
                                                                                ++$errorsCount;
                                                                            }
                                                                            if(!$this->updateEntreeField($deliveryDate,$translationPostID)){
                                                                                $errorOnTranslationUpdate = true;
                                                                                ++$errorsCount;
                                                                            }

                                                                            // description
                                                                            $description = $this->returnDescriptionFromPublicRequestData($publicRequestData,$mainCategoryMap->softunik_site_id,$translationCode2char);
                                                                            if($description === false){
                                                                                $errorOnTranslationUpdate = true;
                                                                                ++$errorsCount;
                                                                            }
                                                                            if(!$this->updateDescriptionField($description,$translationPostID)){
                                                                                $errorOnTranslationUpdate = true;
                                                                                ++$errorsCount;
                                                                            }

                                                                            // competences
                                                                            $assets = $this->returnAssetsFromPublicRequestData($publicRequestData,$mainCategoryMap->softunik_site_id,$translationCode2char);
                                                                            if($assets === false){
                                                                                $errorOnTranslationUpdate = true;
                                                                                ++$errorsCount;
                                                                            }
                                                                            if(!$this->updateCompetencesField($assets,$translationPostID)){
                                                                                $errorOnTranslationUpdate = true;
                                                                                ++$errorsCount;
                                                                            }

                                                                            // exigences
                                                                            $skills = $this->returnSkillsFromPublicRequestData($publicRequestData,$mainCategoryMap->softunik_site_id,$translationCode2char);
                                                                            if($skills === false){
                                                                                $errorOnTranslationUpdate = true;
                                                                                ++$errorsCount;
                                                                            }
                                                                            if(!$this->updateExigencesField($skills,$translationPostID)){
                                                                                $errorOnTranslationUpdate = true;
                                                                                ++$errorsCount;
                                                                            }

                                                                            // niveau_scolaire
                                                                            //update_field('field_5c5b412d82120', 'High School/Secondaire', $translationPostID);
                                                                            //update_field('niveau_scolaire', 'High School/Secondaire', $translationPostID);

                                                                            // diplome
                                                                            //$diplomas = $this->returnDiplomasFromPublicRequestData($publicRequestData);
                                                                            //if($diplomas === false){
                                                                            //    $errorOnUpdate = true;
                                                                            //    ++$errorsCount;
                                                                            //}
                                                                            if(!$this->updateDiplomeField($diplomas,$translationPostID)){
                                                                                $errorOnTranslationUpdate = true;
                                                                                ++$errorsCount;
                                                                            }

                                                                            // experiences
                                                                            //update_field('field_5c5b413c82122', '1-2 years in factory/1-2 années en usine', $translationPostID);
                                                                            //update_field('experiences', '1-2 years in factory/1-2 années en usine', $translationPostID);

                                                                            // langues_ecrites
                                                                            //$writtenLanguages = $this->returnWrittenLanguagesFromPublicRequestData($publicRequestData);
                                                                            //if($writtenLanguages === false){
                                                                            //    $errorOnUpdate = true;
                                                                            //    ++$errorsCount;
                                                                            //}
                                                                            if(!$this->updateLanguesEcritesField($writtenLanguages,$translationPostID)){
                                                                                $errorOnTranslationUpdate = true;
                                                                                ++$errorsCount;
                                                                            }

                                                                            // langues_parlees
                                                                            //$spokenLanguages = $this->returnSpokenLanguagesFromPublicRequestData($publicRequestData);
                                                                            //if($spokenLanguages === false){
                                                                            //    $errorOnUpdate = true;
                                                                            //    ++$errorsCount;
                                                                            //}
                                                                            if(!$this->updateLanguesParleesField($spokenLanguages,$translationPostID)){
                                                                                $errorOnTranslationUpdate = true;
                                                                                ++$errorsCount;
                                                                            }
                                                                        }
                                                                        catch(Exception $e){
                                                                            $errorOnTranslationUpdate = true;
                                                                            ++$errorsCount;
                                                                            $this->log("Error: " . $e->getMessage(), $this->configuration->LOG_TYPE_ERROR);
                                                                        }

                                                                        if(!$errorOnTranslationUpdate){
                                                                            ++$careerTranslationsUpdatedWithoutErrorsCount;
                                                                            $this->log("The career translation update completed without errors.", $this->configuration->LOG_TYPE_INFO | $this->configuration->LOG_TYPE_DEBUG);
                                                                        }
                                                                    }
                                                                    else{
                                                                        // Inserting new career translation as non was found.
                                                                        ++$careerTranslationsCreatedCount;
                                                                        $errorOnTranslationCreate = false;

                                                                        $translationLocale = $translationLocaleMap->locale;
                                                                        $translationCode2char = $locales[$translationLocaleMap->locale]->code2char;

                                                                        if ( is_textdomain_loaded( 'mxo-softunik' ) ) {
                                                                            unload_textdomain( 'mxo-softunik' );
                                                                        }
                                                                        $textDomainLoaded = load_textdomain( 'mxo-softunik', path_join( \MxoSoftunikPlugin::returnPath(), sprintf( 'i18n/%s.mo', $translationLocale ) ) );

                                                                        $this->log("Starting the creation of career translation.", $this->configuration->LOG_TYPE_INFO | $this->configuration->LOG_TYPE_DEBUG);

                                                                        $translationPostID = null;

                                                                        try{
                                                                            $this->log(preg_replace('#\n$#','',print_r([
                                                                                'locale' => $translationLocale,
                                                                                'category id' => $translationCategoryId,
                                                                            ],true)), $this->configuration->LOG_TYPE_INFO | $this->configuration->LOG_TYPE_DEBUG);

                                                                            $title = null;
                                                                            if(
                                                                                isset($publicRequestData["{$translationCode2char}_title"])
                                                                                && !empty(trim($publicRequestData["{$translationCode2char}_title"]))
                                                                            ){
                                                                                $title = $publicRequestData["{$translationCode2char}_title"];
                                                                            }
                                                                            //else{
                                                                            //    // Picking first none empty title
                                                                            //    $titleKey = null;
                                                                            //    $titleKeys = preg_grep('#^.+?_title$#',array_keys($publicRequestData));
                                                                            //    if(!empty($titleKeys)){
                                                                            //        foreach($titleKeys as $t_titleKey){
                                                                            //            if(!empty(trim($publicRequestData[$t_titleKey]))){
                                                                            //                $titleKey = $t_titleKey;
                                                                            //                break;
                                                                            //            }
                                                                            //        }
                                                                            //    }
                                                                            //    if(isset($titleKey)){
                                                                            //        $title = $publicRequestData[$titleKey];
                                                                            //    }
                                                                            //}

                                                                            if(empty($title)){
                                                                                throw new Exception("The '{$translationCode2char}' title for Softunik public request '{$publicRequestData['id']}' from Softunik site '{$mainCategoryMap->softunik_site_id}' must exist and not be empty.");
                                                                            }

                                                                            $this->log("Title is '{$title}'.", $this->configuration->LOG_TYPE_DEBUG);

                                                                            $translationInsertResult = wp_insert_post(array(
                                                                                'post_type' => 'carrieres-prograin',
                                                                                'post_title' => $title,
                                                                                'post_name' => sanitize_title($title),
                                                                            ));

                                                                            if(empty($translationInsertResult)) {
                                                                                throw new Exception("Error: Career translation with post_title and post_name creation failed.");
                                                                            }

                                                                            $this->log("Career translation with post_title and post_name created with success.", $this->configuration->LOG_TYPE_DEBUG);

                                                                            $translationPostID = $translationInsertResult;
                                                                            $careerTranslations[$translationSlug] = $translationPostID;

                                                                            $translationCategoryUpdateResult = wp_set_object_terms($translationPostID, $translationCategoryId, 'carrieres-cat', false);

                                                                            if($translationCategoryUpdateResult) {
                                                                                $this->log("Updated career translation category with success.", $this->configuration->LOG_TYPE_INFO | $this->configuration->LOG_TYPE_DEBUG);
                                                                            }else{
                                                                                $errorOnTranslationCreate = true;
                                                                                ++$errorsCount;
                                                                                $this->log("Error: Career category translation update failed.", $this->configuration->LOG_TYPE_ERROR | $this->configuration->LOG_TYPE_DEBUG);
                                                                            }

                                                                            if(!function_exists('get_field')){
                                                                                throw new Exception("All the career translation metas update failed because the 'get_field' function is needed.");
                                                                            }

                                                                            if(!function_exists('update_field')){
                                                                                throw new Exception("All the career translation metas update failed because the 'update_field' function is needed.");
                                                                            }

                                                                            // softunik_public_request_id
                                                                            // update_field('field_803aee254165043',$publicRequestData['id'],$translationPostID);

                                                                            // horaire
                                                                            $duration = $this->returnDurationFromPublicRequestData($publicRequestData,$mainCategoryMap->softunik_site_id,$translationCode2char);
                                                                            if($duration === false){
                                                                                $errorOnTranslationCreate = true;
                                                                                ++$errorsCount;
                                                                            }
                                                                            if(!$this->updateHoraireField($duration,$translationPostID)){
                                                                                $errorOnTranslationCreate = true;
                                                                                ++$errorsCount;
                                                                            }

                                                                            // Getting job_types to update quart and statut fields
                                                                            //$jobTypes = $this->returnJobTypesFromPublicRequestData($publicRequestData,$mainCategoryMap->softunik_site_id,$translationCode2char);
                                                                            //if($jobTypes === false){
                                                                            //    $errorOnTranslationUpdate = true;
                                                                            //    ++$errorsCount;
                                                                            //}

                                                                            // quart
                                                                            if(!$this->updateQuartField($jobTypes,$translationPostID)){
                                                                                $errorOnTranslationCreate = true;
                                                                                ++$errorsCount;
                                                                            }

                                                                            // statut
                                                                            if(!$this->updateStatutField($jobTypes,$translationPostID)){
                                                                                $errorOnTranslationCreate = true;
                                                                                ++$errorsCount;
                                                                            }

                                                                            // entree
                                                                            $deliveryDate = $this->returnDeliveryDateFromPublicRequestData($publicRequestData,$mainCategoryMap->softunik_site_id,$translationCode2char);
                                                                            if($deliveryDate === false){
                                                                                $errorOnTranslationCreate = true;
                                                                                ++$errorsCount;
                                                                            }
                                                                            if(!$this->updateEntreeField($deliveryDate,$translationPostID)){
                                                                                $errorOnTranslationCreate = true;
                                                                                ++$errorsCount;
                                                                            }

                                                                            // description
                                                                            $description = $this->returnDescriptionFromPublicRequestData($publicRequestData,$mainCategoryMap->softunik_site_id,$translationCode2char);
                                                                            if($description === false){
                                                                                $errorOnTranslationCreate = true;
                                                                                ++$errorsCount;
                                                                            }
                                                                            if(!$this->updateDescriptionField($description,$translationPostID)){
                                                                                $errorOnTranslationCreate = true;
                                                                                ++$errorsCount;
                                                                            }

                                                                            // competences
                                                                            $assets = $this->returnAssetsFromPublicRequestData($publicRequestData,$mainCategoryMap->softunik_site_id,$translationCode2char);
                                                                            if($assets === false){
                                                                                $errorOnTranslationCreate = true;
                                                                                ++$errorsCount;
                                                                            }
                                                                            if(!$this->updateCompetencesField($assets,$translationPostID)){
                                                                                $errorOnTranslationCreate = true;
                                                                                ++$errorsCount;
                                                                            }

                                                                            // exigences
                                                                            $skills = $this->returnSkillsFromPublicRequestData($publicRequestData,$mainCategoryMap->softunik_site_id,$translationCode2char);
                                                                            if($skills === false){
                                                                                $errorOnTranslationCreate = true;
                                                                                ++$errorsCount;
                                                                            }
                                                                            if(!$this->updateExigencesField($skills,$translationPostID)){
                                                                                $errorOnTranslationCreate = true;
                                                                                ++$errorsCount;
                                                                            }

                                                                            // niveau_scolaire
                                                                            //update_field('field_5c5b412d82120', 'High School/Secondaire', $translationPostID);
                                                                            //update_field('niveau_scolaire', 'High School/Secondaire', $translationPostID);

                                                                            // diplome
                                                                            //$diplomas = $this->returnDiplomasFromPublicRequestData($publicRequestData);
                                                                            //if($diplomas === false){
                                                                            //    $errorOnUpdate = true;
                                                                            //    ++$errorsCount;
                                                                            //}
                                                                            if(!$this->updateDiplomeField($diplomas,$translationPostID)){
                                                                                $errorOnTranslationCreate = true;
                                                                                ++$errorsCount;
                                                                            }

                                                                            // experiences
                                                                            //update_field('field_5c5b413c82122', '1-2 years in factory/1-2 années en usine', $translationPostID);
                                                                            //update_field('experiences', '1-2 years in factory/1-2 années en usine', $translationPostID);

                                                                            // langues_ecrites
                                                                            //$writtenLanguages = $this->returnWrittenLanguagesFromPublicRequestData($publicRequestData);
                                                                            //if($writtenLanguages === false){
                                                                            //    $errorOnUpdate = true;
                                                                            //    ++$errorsCount;
                                                                            //}
                                                                            if(!$this->updateLanguesEcritesField($writtenLanguages,$translationPostID)){
                                                                                $errorOnTranslationCreate = true;
                                                                                ++$errorsCount;
                                                                            }

                                                                            // langues_parlees
                                                                            //$spokenLanguages = $this->returnSpokenLanguagesFromPublicRequestData($publicRequestData);
                                                                            //if($spokenLanguages === false){
                                                                            //    $errorOnUpdate = true;
                                                                            //    ++$errorsCount;
                                                                            //}
                                                                            if(!$this->updateLanguesParleesField($spokenLanguages,$translationPostID)){
                                                                                $errorOnTranslationCreate = true;
                                                                                ++$errorsCount;
                                                                            }
                                                                        }
                                                                        catch(Exception $e){
                                                                            $errorOnTranslationCreate = true;
                                                                            ++$errorsCount;
                                                                            $this->log("Error: " . $e->getMessage(), $this->configuration->LOG_TYPE_ERROR);
                                                                        }

                                                                        if(!$errorOnTranslationCreate){
                                                                            ++$careerTranslationsCreatedWithoutErrorsCount;

                                                                            if(isset($translationPostID)) {
                                                                                wp_publish_post($translationPostID);
                                                                            }

                                                                            $this->log("The career translation creation completed without errors.", $this->configuration->LOG_TYPE_INFO | $this->configuration->LOG_TYPE_DEBUG);
                                                                        }
                                                                    }
                                                                }
                                                                else{
                                                                    $errorOnUpdate = true;
                                                                    ++$errorsCount;
                                                                    $this->log("Error: The '{$translationLocaleMap->locale}' translation category doesn't exist for main category '{$mainCategoryMap->category_id}'.", $this->configuration->LOG_TYPE_ERROR | $this->configuration->LOG_TYPE_DEBUG);
                                                                }
                                                            }
                                                            catch(Exception $e){
                                                                $errorOnUpdate = true;
                                                                ++$errorsCount;
                                                                $this->log("Error: " . $e->getMessage(), $this->configuration->LOG_TYPE_ERROR);
                                                            }
                                                        }

                                                        pll_save_post_translations($careerTranslations);
                                                    }

                                                    if(!$errorOnUpdate){
                                                        ++$careersUpdatedWithoutErrorsCount;
                                                        $this->log("The career update completed without errors.", $this->configuration->LOG_TYPE_INFO | $this->configuration->LOG_TYPE_DEBUG);
                                                    }
                                                }
                                                else{
                                                    // Inserting new career if query returned no result.
                                                    ++$careersCreatedCount;
                                                    $errorOnCreate = false;

                                                    $this->log("Starting the creation of career.", $this->configuration->LOG_TYPE_INFO | $this->configuration->LOG_TYPE_DEBUG);
                                                    $this->log(preg_replace('#\n$#','',print_r([
                                                        'site' => $siteID,
                                                        'locale' => $mainLocale,
                                                        'category id' => $mainCategory->term_id,
                                                        'Softunik public request id' => $publicRequestData['id'],
                                                        'Softunik site id' => $mainCategoryMap->softunik_site_id,
                                                    ],true)), $this->configuration->LOG_TYPE_INFO | $this->configuration->LOG_TYPE_DEBUG);

                                                    $title = null;
                                                    if(
                                                        isset($publicRequestData["{$mainCode2char}_title"])
                                                        && !empty(trim($publicRequestData["{$mainCode2char}_title"]))
                                                    ){
                                                        $title = $publicRequestData["{$mainCode2char}_title"];
                                                    }
                                                    //else{
                                                    //    // Picking first none empty title
                                                    //    $titleKey = null;
                                                    //    $titleKeys = preg_grep('#^.+?_title$#',array_keys($publicRequestData));
                                                    //    if(!empty($titleKeys)){
                                                    //        foreach($titleKeys as $t_titleKey){
                                                    //            if(!empty(trim($publicRequestData[$t_titleKey]))){
                                                    //                $titleKey = $t_titleKey;
                                                    //                break;
                                                    //            }
                                                    //        }
                                                    //    }
                                                    //    if(isset($titleKey)){
                                                    //        $title = $publicRequestData[$titleKey];
                                                    //    }
                                                    //}

                                                    if(empty($title)){
                                                        throw new Exception("The '{$mainCode2char}' title for Softunik public request '{$publicRequestData['id']}' from Softunik site '{$mainCategoryMap->softunik_site_id}' must exist and not be empty.");
                                                    }

                                                    //$this->log("Title is '{$title}'.", $this->configuration->LOG_TYPE_DEBUG);

                                                    $mainInsertResult = wp_insert_post(array(
                                                        'post_type' => 'carrieres-prograin',
                                                        'post_title' => $title,
                                                        'post_name' => sanitize_title($title),
                                                    ));

                                                    if(empty($mainInsertResult)) {
                                                        throw new Exception("Error: Career with post_title and post_name creation failed.");
                                                    }

                                                    $this->log("Career with post_title and post_name created with success.", $this->configuration->LOG_TYPE_DEBUG);

                                                    $mainPostID = $mainInsertResult;

                                                    if($translationMethodUsed==='polylang') {
                                                        if(isset($mainTranslationSlug)){
                                                            pll_set_post_language($mainPostID,$mainTranslationSlug);
                                                        }
                                                    }

                                                    $mainCategoryUpdateResult = wp_set_object_terms($mainPostID, $mainCategory->term_id, 'carrieres-cat', false);

                                                    if($mainCategoryUpdateResult) {
                                                        $this->log("Updated career category with success.", $this->configuration->LOG_TYPE_INFO | $this->configuration->LOG_TYPE_DEBUG);
                                                    }else{
                                                        $errorOnCreate = true;
                                                        ++$errorsCount;
                                                        $this->log("Error: Career category update failed.", $this->configuration->LOG_TYPE_ERROR | $this->configuration->LOG_TYPE_DEBUG);
                                                    }

                                                    if(!function_exists('get_field')){
                                                        throw new Exception("All the career metas update failed because the 'get_field' function is needed.");
                                                    }

                                                    if(!function_exists('update_field')){
                                                        throw new Exception("All the career metas update failed because the 'update_field' function is needed.");
                                                    }

                                                    // softunik_public_request_id
                                                    // update_field('field_803aee254165043',$publicRequestData['id'],$mainPostID);
                                                    update_field('softunik_public_request_id',$publicRequestData['id'],$mainPostID);

                                                    // horaire
                                                    $duration = $this->returnDurationFromPublicRequestData($publicRequestData,$mainCategoryMap->softunik_site_id,$mainCode2char);
                                                    if($duration === false){
                                                        $errorOnCreate = true;
                                                        ++$errorsCount;
                                                    }
                                                    if(!$this->updateHoraireField($duration,$mainPostID)){
                                                        $errorOnCreate = true;
                                                        ++$errorsCount;
                                                    }

                                                    // Getting job_types to update quart and statut fields
                                                    $jobTypes = $this->returnJobTypesFromPublicRequestData($publicRequestData,$mainCategoryMap->softunik_site_id,$mainCode2char);
                                                    if($jobTypes === false){
                                                        $errorOnCreate = true;
                                                        ++$errorsCount;
                                                    }

                                                    // quart
                                                    if(!$this->updateQuartField($jobTypes,$mainPostID)){
                                                        $errorOnCreate = true;
                                                        ++$errorsCount;
                                                    }

                                                    // statut
                                                    if(!$this->updateStatutField($jobTypes,$mainPostID)){
                                                        $errorOnCreate = true;
                                                        ++$errorsCount;
                                                    }

                                                    // entree
                                                    $deliveryDate = $this->returnDeliveryDateFromPublicRequestData($publicRequestData,$mainCategoryMap->softunik_site_id,$mainCode2char);
                                                    if($deliveryDate === false){
                                                        $errorOnCreate = true;
                                                        ++$errorsCount;
                                                    }
                                                    if(!$this->updateEntreeField($deliveryDate,$mainPostID)){
                                                        $errorOnCreate = true;
                                                        ++$errorsCount;
                                                    }

                                                    // description
                                                    $description = $this->returnDescriptionFromPublicRequestData($publicRequestData,$mainCategoryMap->softunik_site_id,$mainCode2char);
                                                    if($description === false){
                                                        $errorOnCreate = true;
                                                        ++$errorsCount;
                                                    }
                                                    if(!$this->updateDescriptionField($description,$mainPostID)){
                                                        $errorOnCreate = true;
                                                        ++$errorsCount;
                                                    }

                                                    // competences
                                                    $assets = $this->returnAssetsFromPublicRequestData($publicRequestData,$mainCategoryMap->softunik_site_id,$mainCode2char);
                                                    if($assets === false){
                                                        $errorOnCreate = true;
                                                        ++$errorsCount;
                                                    }
                                                    if(!$this->updateCompetencesField($assets,$mainPostID)){
                                                        $errorOnCreate = true;
                                                        ++$errorsCount;
                                                    }

                                                    // exigences
                                                    $skills = $this->returnSkillsFromPublicRequestData($publicRequestData,$mainCategoryMap->softunik_site_id,$mainCode2char);
                                                    if($skills === false){
                                                        $errorOnCreate = true;
                                                        ++$errorsCount;
                                                    }
                                                    if(!$this->updateExigencesField($skills,$mainPostID)){
                                                        $errorOnCreate = true;
                                                        ++$errorsCount;
                                                    }

                                                    // niveau_scolaire
                                                    //update_field('field_5c5b412d82120', 'High School/Secondaire', $mainPostID);
                                                    //update_field('niveau_scolaire', 'High School/Secondaire', $mainPostID);

                                                    // diplome
                                                    $diplomas = $this->returnDiplomasFromPublicRequestData($publicRequestData);
                                                    if($diplomas === false){
                                                        $errorOnCreate = true;
                                                        ++$errorsCount;
                                                    }
                                                    if(!$this->updateDiplomeField($diplomas,$mainPostID)){
                                                        $errorOnCreate = true;
                                                        ++$errorsCount;
                                                    }

                                                    // experiences
                                                    //update_field('field_5c5b413c82122', '1-2 years in factory/1-2 années en usine', $mainPostID);
                                                    //update_field('experiences', '1-2 years in factory/1-2 années en usine', $mainPostID);

                                                    // langues_ecrites
                                                    $writtenLanguages = $this->returnWrittenLanguagesFromPublicRequestData($publicRequestData);
                                                    if($writtenLanguages === false){
                                                        $errorOnCreate = true;
                                                        ++$errorsCount;
                                                    }
                                                    if(!$this->updateLanguesEcritesField($writtenLanguages,$mainPostID)){
                                                        $errorOnCreate = true;
                                                        ++$errorsCount;
                                                    }

                                                    // langues_parlees
                                                    $spokenLanguages = $this->returnSpokenLanguagesFromPublicRequestData($publicRequestData);
                                                    if($spokenLanguages === false){
                                                        $errorOnCreate = true;
                                                        ++$errorsCount;
                                                    }
                                                    if(!$this->updateLanguesParleesField($spokenLanguages,$mainPostID)){
                                                        $errorOnCreate = true;
                                                        ++$errorsCount;
                                                    }

                                                    if($translationMethodUsed==='polylang') {

                                                        $careerTranslations = pll_get_post_translations($mainPostID);

                                                        foreach($softunikConfig->locale_mapping->translations as $translationLocaleMap){
                                                            try{
                                                                $translationSlug = $locales[$translationLocaleMap->locale]->slug;
                                                                if (isset($mainCategoryTranslations[$translationSlug])) {
                                                                    $translationCategoryLocale = $translationLocaleMap->locale;
                                                                    $translationCategoryId = $mainCategoryTranslations[$locales[$translationCategoryLocale]->slug];

                                                                    $this->log("Translation category '{$translationCategoryId}'.", $this->configuration->LOG_TYPE_INFO | $this->configuration->LOG_TYPE_DEBUG);

                                                                    if(isset($careerTranslations[$translationSlug])){
                                                                        // Updating found career translation.
                                                                        ++$careerTranslationsUpdatedCount;
                                                                        $errorOnTranslationUpdate = false;

                                                                        $translationPostID = $careerTranslations[$translationSlug];

                                                                        $translationLocale = $translationLocaleMap->locale;
                                                                        $translationCode2char = $locales[$translationLocaleMap->locale]->code2char;

                                                                        if ( is_textdomain_loaded( 'mxo-softunik' ) ) {
                                                                            unload_textdomain( 'mxo-softunik' );
                                                                        }
                                                                        $textDomainLoaded = load_textdomain( 'mxo-softunik', path_join( \MxoSoftunikPlugin::returnPath(), sprintf( 'i18n/%s.mo', $translationLocale ) ) );

                                                                        $this->log("Starting the update of career translation.", $this->configuration->LOG_TYPE_INFO | $this->configuration->LOG_TYPE_DEBUG);
                                                                        try{
                                                                            $this->log(preg_replace('#\n$#','',print_r([
                                                                                'id' => $translationPostID,
                                                                                'locale' => $translationLocale,
                                                                                'category id' => $translationCategoryId,
                                                                            ],true)), $this->configuration->LOG_TYPE_INFO | $this->configuration->LOG_TYPE_DEBUG);

                                                                            $title = null;
                                                                            if(
                                                                                isset($publicRequestData["{$translationCode2char}_title"])
                                                                                && !empty(trim($publicRequestData["{$translationCode2char}_title"]))
                                                                            ){
                                                                                $title = $publicRequestData["{$translationCode2char}_title"];
                                                                            }
                                                                            //else{
                                                                            //    // Picking first none empty title
                                                                            //    $titleKey = null;
                                                                            //    $titleKeys = preg_grep('#^.+?_title$#',array_keys($publicRequestData));
                                                                            //    if(!empty($titleKeys)){
                                                                            //        foreach($titleKeys as $t_titleKey){
                                                                            //            if(!empty(trim($publicRequestData[$t_titleKey]))){
                                                                            //                $titleKey = $t_titleKey;
                                                                            //                break;
                                                                            //            }
                                                                            //        }
                                                                            //    }
                                                                            //    if(isset($titleKey)){
                                                                            //        $title = $publicRequestData[$titleKey];
                                                                            //    }
                                                                            //}

                                                                            if(empty($title)){
                                                                                throw new Exception("The '{$translationCode2char}' title for Softunik public request '{$publicRequestData['id']}' from Softunik site '{$mainCategoryMap->softunik_site_id}' must exist and not be empty.");
                                                                            }

                                                                            $this->log("Title is '{$title}'.", $this->configuration->LOG_TYPE_DEBUG);

                                                                            $translationUpdateResult = wp_update_post(array(
                                                                                'ID' => $translationPostID,
                                                                                'post_title' => $title,
                                                                                'post_name' => sanitize_title($title),
                                                                            ));

                                                                            if($translationUpdateResult) {
                                                                                $this->log("Updated career translation post_title and post_name with success.", $this->configuration->LOG_TYPE_DEBUG);
                                                                            }
                                                                            else{
                                                                                $errorOnTranslationUpdate = true;
                                                                                ++$errorsCount;
                                                                                $this->log("Error: Career translation post_title and post_name update failed.", $this->configuration->LOG_TYPE_ERROR | $this->configuration->LOG_TYPE_DEBUG);
                                                                            }

                                                                            $translationCategoryUpdateResult = wp_set_object_terms($translationPostID, $translationCategoryId, 'carrieres-cat', false);

                                                                            if($translationCategoryUpdateResult) {
                                                                                $this->log("Updated career translation category with success.", $this->configuration->LOG_TYPE_INFO | $this->configuration->LOG_TYPE_DEBUG);
                                                                            }else{
                                                                                $errorOnTranslationUpdate = true;
                                                                                ++$errorsCount;
                                                                                $this->log("Error: Career category translation update failed.", $this->configuration->LOG_TYPE_ERROR | $this->configuration->LOG_TYPE_DEBUG);
                                                                            }

                                                                            if(!function_exists('get_field')){
                                                                                throw new Exception("All the career translation metas update failed because the 'get_field' function is needed.");
                                                                            }

                                                                            if(!function_exists('update_field')){
                                                                                throw new Exception("All the career translation metas update failed because the 'update_field' function is needed.");
                                                                            }

                                                                            // softunik_public_request_id
                                                                            // update_field('field_803aee254165043',$publicRequestData['id'],$translationPostID);

                                                                            // horaire
                                                                            $duration = $this->returnDurationFromPublicRequestData($publicRequestData,$mainCategoryMap->softunik_site_id,$translationCode2char);
                                                                            if($duration === false){
                                                                                $errorOnTranslationUpdate = true;
                                                                                ++$errorsCount;
                                                                            }
                                                                            if(!$this->updateHoraireField($duration,$translationPostID)){
                                                                                $errorOnTranslationUpdate = true;
                                                                                ++$errorsCount;
                                                                            }

                                                                            // Getting job_types to update quart and statut fields
                                                                            //$jobTypes = $this->returnJobTypesFromPublicRequestData($publicRequestData,$mainCategoryMap->softunik_site_id,$translationCode2char);
                                                                            //if($jobTypes === false){
                                                                            //    $errorOnTranslationUpdate = true;
                                                                            //    ++$errorsCount;
                                                                            //}

                                                                            // quart
                                                                            if(!$this->updateQuartField($jobTypes,$translationPostID)){
                                                                                $errorOnTranslationUpdate = true;
                                                                                ++$errorsCount;
                                                                            }

                                                                            // statut
                                                                            if(!$this->updateStatutField($jobTypes,$translationPostID)){
                                                                                $errorOnTranslationUpdate = true;
                                                                                ++$errorsCount;
                                                                            }

                                                                            // entree
                                                                            $deliveryDate = $this->returnDeliveryDateFromPublicRequestData($publicRequestData,$mainCategoryMap->softunik_site_id,$translationCode2char);
                                                                            if($deliveryDate === false){
                                                                                $errorOnTranslationUpdate = true;
                                                                                ++$errorsCount;
                                                                            }
                                                                            if(!$this->updateEntreeField($deliveryDate,$translationPostID)){
                                                                                $errorOnTranslationUpdate = true;
                                                                                ++$errorsCount;
                                                                            }

                                                                            // description
                                                                            $description = $this->returnDescriptionFromPublicRequestData($publicRequestData,$mainCategoryMap->softunik_site_id,$translationCode2char);
                                                                            if($description === false){
                                                                                $errorOnTranslationUpdate = true;
                                                                                ++$errorsCount;
                                                                            }
                                                                            if(!$this->updateDescriptionField($description,$translationPostID)){
                                                                                $errorOnTranslationUpdate = true;
                                                                                ++$errorsCount;
                                                                            }

                                                                            // competences
                                                                            $assets = $this->returnAssetsFromPublicRequestData($publicRequestData,$mainCategoryMap->softunik_site_id,$translationCode2char);
                                                                            if($assets === false){
                                                                                $errorOnTranslationUpdate = true;
                                                                                ++$errorsCount;
                                                                            }
                                                                            if(!$this->updateCompetencesField($assets,$translationPostID)){
                                                                                $errorOnTranslationUpdate = true;
                                                                                ++$errorsCount;
                                                                            }

                                                                            // exigences
                                                                            $skills = $this->returnSkillsFromPublicRequestData($publicRequestData,$mainCategoryMap->softunik_site_id,$translationCode2char);
                                                                            if($skills === false){
                                                                                $errorOnTranslationUpdate = true;
                                                                                ++$errorsCount;
                                                                            }
                                                                            if(!$this->updateExigencesField($skills,$translationPostID)){
                                                                                $errorOnTranslationUpdate = true;
                                                                                ++$errorsCount;
                                                                            }

                                                                            // niveau_scolaire
                                                                            //update_field('field_5c5b412d82120', 'High School/Secondaire', $translationPostID);
                                                                            //update_field('niveau_scolaire', 'High School/Secondaire', $translationPostID);

                                                                            // diplome
                                                                            //$diplomas = $this->returnDiplomasFromPublicRequestData($publicRequestData);
                                                                            //if($diplomas === false){
                                                                            //    $errorOnUpdate = true;
                                                                            //    ++$errorsCount;
                                                                            //}
                                                                            if(!$this->updateDiplomeField($diplomas,$translationPostID)){
                                                                                $errorOnTranslationUpdate = true;
                                                                                ++$errorsCount;
                                                                            }

                                                                            // experiences
                                                                            //update_field('field_5c5b413c82122', '1-2 years in factory/1-2 années en usine', $translationPostID);
                                                                            //update_field('experiences', '1-2 years in factory/1-2 années en usine', $translationPostID);

                                                                            // langues_ecrites
                                                                            //$writtenLanguages = $this->returnWrittenLanguagesFromPublicRequestData($publicRequestData);
                                                                            //if($writtenLanguages === false){
                                                                            //    $errorOnUpdate = true;
                                                                            //    ++$errorsCount;
                                                                            //}
                                                                            if(!$this->updateLanguesEcritesField($writtenLanguages,$translationPostID)){
                                                                                $errorOnTranslationUpdate = true;
                                                                                ++$errorsCount;
                                                                            }

                                                                            // langues_parlees
                                                                            //$spokenLanguages = $this->returnSpokenLanguagesFromPublicRequestData($publicRequestData);
                                                                            //if($spokenLanguages === false){
                                                                            //    $errorOnUpdate = true;
                                                                            //    ++$errorsCount;
                                                                            //}
                                                                            if(!$this->updateLanguesParleesField($spokenLanguages,$translationPostID)){
                                                                                $errorOnTranslationUpdate = true;
                                                                                ++$errorsCount;
                                                                            }
                                                                        }
                                                                        catch(Exception $e){
                                                                            $errorOnTranslationUpdate = true;
                                                                            ++$errorsCount;
                                                                            $this->log("Error: " . $e->getMessage(), $this->configuration->LOG_TYPE_ERROR);
                                                                        }

                                                                        if(!$errorOnTranslationUpdate){
                                                                            ++$careerTranslationsUpdatedWithoutErrorsCount;
                                                                            $this->log("The career translation update completed without errors.", $this->configuration->LOG_TYPE_INFO | $this->configuration->LOG_TYPE_DEBUG);
                                                                        }
                                                                    }
                                                                    else{
                                                                        // Inserting new career translation as non was found.
                                                                        ++$careerTranslationsCreatedCount;
                                                                        $errorOnTranslationCreate = false;

                                                                        $translationLocale = $translationLocaleMap->locale;
                                                                        $translationCode2char = $locales[$translationLocaleMap->locale]->code2char;

                                                                        if ( is_textdomain_loaded( 'mxo-softunik' ) ) {
                                                                            unload_textdomain( 'mxo-softunik' );
                                                                        }
                                                                        $textDomainLoaded = load_textdomain( 'mxo-softunik', path_join( \MxoSoftunikPlugin::returnPath(), sprintf( 'i18n/%s.mo', $translationLocale ) ) );

                                                                        $this->log("Starting the creation of career translation.", $this->configuration->LOG_TYPE_INFO | $this->configuration->LOG_TYPE_DEBUG);

                                                                        $translationPostID = null;

                                                                        try{
                                                                            $this->log(preg_replace('#\n$#','',print_r([
                                                                                'locale' => $translationLocale,
                                                                                'category id' => $translationCategoryId,
                                                                            ],true)), $this->configuration->LOG_TYPE_INFO | $this->configuration->LOG_TYPE_DEBUG);

                                                                            $title = null;
                                                                            if(
                                                                                isset($publicRequestData["{$translationCode2char}_title"])
                                                                                && !empty(trim($publicRequestData["{$translationCode2char}_title"]))
                                                                            ){
                                                                                $title = $publicRequestData["{$translationCode2char}_title"];
                                                                            }
                                                                            //else{
                                                                            //    // Picking first none empty title
                                                                            //    $titleKey = null;
                                                                            //    $titleKeys = preg_grep('#^.+?_title$#',array_keys($publicRequestData));
                                                                            //    if(!empty($titleKeys)){
                                                                            //        foreach($titleKeys as $t_titleKey){
                                                                            //            if(!empty(trim($publicRequestData[$t_titleKey]))){
                                                                            //                $titleKey = $t_titleKey;
                                                                            //                break;
                                                                            //            }
                                                                            //        }
                                                                            //    }
                                                                            //    if(isset($titleKey)){
                                                                            //        $title = $publicRequestData[$titleKey];
                                                                            //    }
                                                                            //}

                                                                            if(empty($title)){
                                                                                throw new Exception("The '{$translationCode2char}' title for Softunik public request '{$publicRequestData['id']}' from Softunik site '{$mainCategoryMap->softunik_site_id}' must exist and not be empty.");
                                                                            }

                                                                            $this->log("Title is '{$title}'.", $this->configuration->LOG_TYPE_DEBUG);

                                                                            $translationInsertResult = wp_insert_post(array(
                                                                                'post_type' => 'carrieres-prograin',
                                                                                'post_title' => $title,
                                                                                'post_name' => sanitize_title($title),
                                                                            ));

                                                                            if(empty($translationInsertResult)) {
                                                                                throw new Exception("Error: Career translation with post_title and post_name creation failed.");
                                                                            }

                                                                            $this->log("Career translation with post_title and post_name created with success.", $this->configuration->LOG_TYPE_DEBUG);

                                                                            $translationPostID = $translationInsertResult;
                                                                            $careerTranslations[$translationSlug] = $translationPostID;

                                                                            $translationCategoryUpdateResult = wp_set_object_terms($translationPostID, $translationCategoryId, 'carrieres-cat', false);

                                                                            if($translationCategoryUpdateResult) {
                                                                                $this->log("Updated career translation category with success.", $this->configuration->LOG_TYPE_INFO | $this->configuration->LOG_TYPE_DEBUG);
                                                                            }else{
                                                                                $errorOnTranslationCreate = true;
                                                                                ++$errorsCount;
                                                                                $this->log("Error: Career category translation update failed.", $this->configuration->LOG_TYPE_ERROR | $this->configuration->LOG_TYPE_DEBUG);
                                                                            }

                                                                            if(!function_exists('get_field')){
                                                                                throw new Exception("All the career translation metas update failed because the 'get_field' function is needed.");
                                                                            }

                                                                            if(!function_exists('update_field')){
                                                                                throw new Exception("All the career translation metas update failed because the 'update_field' function is needed.");
                                                                            }

                                                                            // softunik_public_request_id
                                                                            // update_field('field_803aee254165043',$publicRequestData['id'],$translationPostID);

                                                                            // horaire
                                                                            $duration = $this->returnDurationFromPublicRequestData($publicRequestData,$mainCategoryMap->softunik_site_id,$translationCode2char);
                                                                            if($duration === false){
                                                                                $errorOnTranslationCreate = true;
                                                                                ++$errorsCount;
                                                                            }
                                                                            if(!$this->updateHoraireField($duration,$translationPostID)){
                                                                                $errorOnTranslationCreate = true;
                                                                                ++$errorsCount;
                                                                            }

                                                                            // Getting job_types to update quart and statut fields
                                                                            //$jobTypes = $this->returnJobTypesFromPublicRequestData($publicRequestData,$mainCategoryMap->softunik_site_id,$translationCode2char);
                                                                            //if($jobTypes === false){
                                                                            //    $errorOnTranslationUpdate = true;
                                                                            //    ++$errorsCount;
                                                                            //}

                                                                            // quart
                                                                            if(!$this->updateQuartField($jobTypes,$translationPostID)){
                                                                                $errorOnTranslationCreate = true;
                                                                                ++$errorsCount;
                                                                            }

                                                                            // statut
                                                                            if(!$this->updateStatutField($jobTypes,$translationPostID)){
                                                                                $errorOnTranslationCreate = true;
                                                                                ++$errorsCount;
                                                                            }

                                                                            // entree
                                                                            $deliveryDate = $this->returnDeliveryDateFromPublicRequestData($publicRequestData,$mainCategoryMap->softunik_site_id,$translationCode2char);
                                                                            if($deliveryDate === false){
                                                                                $errorOnTranslationCreate = true;
                                                                                ++$errorsCount;
                                                                            }
                                                                            if(!$this->updateEntreeField($deliveryDate,$translationPostID)){
                                                                                $errorOnTranslationCreate = true;
                                                                                ++$errorsCount;
                                                                            }

                                                                            // description
                                                                            $description = $this->returnDescriptionFromPublicRequestData($publicRequestData,$mainCategoryMap->softunik_site_id,$translationCode2char);
                                                                            if($description === false){
                                                                                $errorOnTranslationCreate = true;
                                                                                ++$errorsCount;
                                                                            }
                                                                            if(!$this->updateDescriptionField($description,$translationPostID)){
                                                                                $errorOnTranslationCreate = true;
                                                                                ++$errorsCount;
                                                                            }

                                                                            // competences
                                                                            $assets = $this->returnAssetsFromPublicRequestData($publicRequestData,$mainCategoryMap->softunik_site_id,$translationCode2char);
                                                                            if($assets === false){
                                                                                $errorOnTranslationCreate = true;
                                                                                ++$errorsCount;
                                                                            }
                                                                            if(!$this->updateCompetencesField($assets,$translationPostID)){
                                                                                $errorOnTranslationCreate = true;
                                                                                ++$errorsCount;
                                                                            }

                                                                            // exigences
                                                                            $skills = $this->returnSkillsFromPublicRequestData($publicRequestData,$mainCategoryMap->softunik_site_id,$translationCode2char);
                                                                            if($skills === false){
                                                                                $errorOnTranslationCreate = true;
                                                                                ++$errorsCount;
                                                                            }
                                                                            if(!$this->updateExigencesField($skills,$translationPostID)){
                                                                                $errorOnTranslationCreate = true;
                                                                                ++$errorsCount;
                                                                            }

                                                                            // niveau_scolaire
                                                                            //update_field('field_5c5b412d82120', 'High School/Secondaire', $translationPostID);
                                                                            //update_field('niveau_scolaire', 'High School/Secondaire', $translationPostID);

                                                                            // diplome
                                                                            //$diplomas = $this->returnDiplomasFromPublicRequestData($publicRequestData);
                                                                            //if($diplomas === false){
                                                                            //    $errorOnUpdate = true;
                                                                            //    ++$errorsCount;
                                                                            //}
                                                                            if(!$this->updateDiplomeField($diplomas,$translationPostID)){
                                                                                $errorOnTranslationCreate = true;
                                                                                ++$errorsCount;
                                                                            }

                                                                            // experiences
                                                                            //update_field('field_5c5b413c82122', '1-2 years in factory/1-2 années en usine', $translationPostID);
                                                                            //update_field('experiences', '1-2 years in factory/1-2 années en usine', $translationPostID);

                                                                            // langues_ecrites
                                                                            //$writtenLanguages = $this->returnWrittenLanguagesFromPublicRequestData($publicRequestData);
                                                                            //if($writtenLanguages === false){
                                                                            //    $errorOnUpdate = true;
                                                                            //    ++$errorsCount;
                                                                            //}
                                                                            if(!$this->updateLanguesEcritesField($writtenLanguages,$translationPostID)){
                                                                                $errorOnTranslationCreate = true;
                                                                                ++$errorsCount;
                                                                            }

                                                                            // langues_parlees
                                                                            //$spokenLanguages = $this->returnSpokenLanguagesFromPublicRequestData($publicRequestData);
                                                                            //if($spokenLanguages === false){
                                                                            //    $errorOnUpdate = true;
                                                                            //    ++$errorsCount;
                                                                            //}
                                                                            if(!$this->updateLanguesParleesField($spokenLanguages,$translationPostID)){
                                                                                $errorOnTranslationCreate = true;
                                                                                ++$errorsCount;
                                                                            }
                                                                        }
                                                                        catch(Exception $e){
                                                                            $errorOnTranslationCreate = true;
                                                                            ++$errorsCount;
                                                                            $this->log("Error: " . $e->getMessage(), $this->configuration->LOG_TYPE_ERROR);
                                                                        }

                                                                        if(!$errorOnTranslationCreate){
                                                                            ++$careerTranslationsCreatedWithoutErrorsCount;

                                                                            if(isset($translationPostID)) {
                                                                                wp_publish_post($translationPostID);
                                                                            }

                                                                            $this->log("The career translation creation completed without errors.", $this->configuration->LOG_TYPE_INFO | $this->configuration->LOG_TYPE_DEBUG);
                                                                        }
                                                                    }
                                                                }
                                                                else{
                                                                    $errorOnCreate = true;
                                                                    ++$errorsCount;
                                                                    $this->log("Error: The '{$translationLocaleMap->locale}' translation category doesn't exist for main category '{$mainCategoryMap->category_id}'.", $this->configuration->LOG_TYPE_ERROR | $this->configuration->LOG_TYPE_DEBUG);
                                                                }
                                                            }
                                                            catch(Exception $e){
                                                                $errorOnCreate = true;
                                                                ++$errorsCount;
                                                                $this->log("Error: " . $e->getMessage(), $this->configuration->LOG_TYPE_ERROR);
                                                            }
                                                        }

                                                        pll_save_post_translations($careerTranslations);
                                                    }

                                                    if(!$errorOnCreate){
                                                        ++$careersCreatedWithoutErrorsCount;

                                                        wp_publish_post($mainPostID);

                                                        $this->log("The career creation completed without errors.", $this->configuration->LOG_TYPE_INFO | $this->configuration->LOG_TYPE_DEBUG);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    catch(Exception $e){
                                        ++$errorsCount;
                                        $this->log("Error: " . $e->getMessage(), $this->configuration->LOG_TYPE_ERROR);
                                    }
                                }

                                // deleting
                                if(!empty($publicRequestDataIDs)){
                                    $sql = "" .
                                        "SELECT  " .
                                        "    t_posts.ID as ID " .
                                        "FROM {$wpdb->base_prefix}{$siteID}_posts t_posts " .
                                        "INNER JOIN {$wpdb->base_prefix}{$siteID}_postmeta t_postmeta ON ( " .
                                        "    t_postmeta.post_id=t_posts.ID " .
                                        ") " .
                                        "WHERE " .
                                        "    t_posts.post_type = 'carrieres-prograin' " .
                                        "    AND t_postmeta.meta_key = 'softunik_public_request_id' " .
                                        "    AND t_postmeta.meta_value REGEXP '^[0-9]+$' " .
                                        "    AND t_postmeta.meta_value NOT IN ('" . implode("','",$publicRequestDataIDs) . "') " .
                                        "";

                                    $toDeleteCareerPostResults = $wpdb->get_results($sql);

                                    if(!empty($toDeleteCareerPostResults)){
                                        foreach($toDeleteCareerPostResults as $toDeleteCareerPostResult){
                                            $toDeleteCareerPostID = (int)$toDeleteCareerPostResult->ID;

                                            ++$careersDeletedCount;
                                            $errorOnDelete = false;

                                            $this->log("Starting the deletion of career.", $this->configuration->LOG_TYPE_INFO | $this->configuration->LOG_TYPE_DEBUG);
                                            $this->log(preg_replace('#\n$#','',print_r([
                                                'id' => $toDeleteCareerPostID,
                                                'site' => $siteID,
                                            ],true)), $this->configuration->LOG_TYPE_INFO | $this->configuration->LOG_TYPE_DEBUG);

                                            if($translationMethodUsed==='polylang') {
                                                $toDeleteCareerTranslations = pll_get_post_translations($toDeleteCareerPostID);

                                                if(!empty($toDeleteCareerTranslations)){
                                                    $toDeleteCareerTranslations = array_diff($toDeleteCareerTranslations,[$toDeleteCareerPostID]);
                                                }

                                                if(!empty($toDeleteCareerTranslations)){
                                                    foreach($toDeleteCareerTranslations as $toDeleteCareerTranslationPostID){
                                                        ++$careerTranslationsDeletedCount;
                                                        $errorOnTranslationDelete = false;

                                                        $this->log("Starting the deletion of career translation.", $this->configuration->LOG_TYPE_INFO | $this->configuration->LOG_TYPE_DEBUG);
                                                        $this->log(preg_replace('#\n$#','',print_r([
                                                            'id' => $toDeleteCareerTranslationPostID,
                                                            'site' => $siteID,
                                                        ],true)), $this->configuration->LOG_TYPE_INFO | $this->configuration->LOG_TYPE_DEBUG);

                                                        $translationDeleteResult = wp_delete_post($toDeleteCareerTranslationPostID,true);

                                                        if(empty($translationDeleteResult)) {
                                                            ++$errorsCount;
                                                            $errorOnTranslationDelete = true;
                                                        }

                                                        if(!$errorOnTranslationDelete){
                                                            ++$careerTranslationsDeletedWithoutErrorsCount;
                                                            $this->log("The career translation deletion completed without errors.", $this->configuration->LOG_TYPE_INFO | $this->configuration->LOG_TYPE_DEBUG);
                                                        }
                                                    }
                                                }
                                            }

                                            $deleteResult = wp_delete_post($toDeleteCareerPostID,true);

                                            if(empty($deleteResult)) {
                                                ++$errorsCount;
                                                $errorOnDelete = true;
                                            }

                                            if(!$errorOnDelete){
                                                ++$careersDeletedWithoutErrorsCount;
                                                $this->log("The career deletion completed without errors.", $this->configuration->LOG_TYPE_INFO | $this->configuration->LOG_TYPE_DEBUG);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        catch(Exception $e){
                            ++$errorsCount;
                            $this->log("Error: " . $e->getMessage(), $this->configuration->LOG_TYPE_ERROR);
                        }
                    }
                }
            }
            else{
                // TODO: code if not in multisite
            }
        } catch (Exception $e) {
            ++$errorsCount;
            $this->log("Error: " . $e->getMessage(), $this->configuration->LOG_TYPE_ERROR);
        }

        $this->log("Created '{$careersCreatedWithoutErrorsCount}' careers without any errors on '{$careersCreatedCount}' attempts.", $this->configuration->LOG_TYPE_RESULT);
        $this->log("Updated '{$careersUpdatedWithoutErrorsCount}' careers without any errors on '{$careersUpdatedCount}' attempts.", $this->configuration->LOG_TYPE_RESULT);
        $this->log("Created '{$careerTranslationsCreatedWithoutErrorsCount}' career translations without any errors on '{$careerTranslationsCreatedCount}' attempts.", $this->configuration->LOG_TYPE_RESULT);
        $this->log("Updated '{$careerTranslationsUpdatedWithoutErrorsCount}' career translations without any errors on '{$careerTranslationsUpdatedCount}' attempts.", $this->configuration->LOG_TYPE_RESULT);
        $this->log("Total careers synced '" . ($careersCreatedWithoutErrorsCount + $careersUpdatedWithoutErrorsCount) . "' without any errors on '" . ($careersCreatedCount + $careersUpdatedCount) . "' attempts.", $this->configuration->LOG_TYPE_RESULT);
        $this->log("Total career translations synced '" . ($careerTranslationsCreatedWithoutErrorsCount + $careerTranslationsUpdatedWithoutErrorsCount) . "' without any errors on '" . ($careerTranslationsCreatedCount + $careerTranslationsUpdatedCount) . "' attempts.", $this->configuration->LOG_TYPE_RESULT);
        $this->log("Total careers deleted '{$careersDeletedWithoutErrorsCount}' careers without any errors on '{$careersDeletedCount}' attempts.", $this->configuration->LOG_TYPE_RESULT);
        $this->log("Total career translations deleted '{$careerTranslationsDeletedWithoutErrorsCount}' career translations without any errors on '{$careerTranslationsDeletedCount}' attempts.", $this->configuration->LOG_TYPE_RESULT);

        if($errorsCount>0){
            $this->log("Total errors: '" . ($errorsCount) . "'!", $this->configuration->LOG_TYPE_RESULT);
        }

        $endDateTime = new DateTime('now', new DateTimeZone($this->configuration->DATE_TIMEZONE));
        $endDateTimeFormatted = $endDateTime->format('Y-m-d H:i:s') . " {$this->configuration->DATE_TIMEZONE_CODE}";
        $this->log("Ended at '{$endDateTimeFormatted}'.", $this->configuration->LOG_TYPE_RESULT);

        $this->notifyDefault();
    }

    /**
     * @param $publicRequestData
     * @param $softunikSiteId
     * @param $code2char
     * @return bool|null
     * @throws Exception
     */
    protected function returnDurationFromPublicRequestData($publicRequestData,$softunikSiteId,$code2char){
        $duration = null;
        if(isset($publicRequestData['duration']) && !empty($publicRequestData['duration'])){
            $scheduleFields = $publicRequestData['duration'];

            if(isset($scheduleFields["description_{$code2char}"])){
                $duration = $scheduleFields["description_{$code2char}"];
            }
            else{
                $this->log("Error: The '{$code2char}' duration for Softunik public request '{$publicRequestData['id']}' from Softunik site '{$softunikSiteId}' doesn't exist.", $this->configuration->LOG_TYPE_ERROR | $this->configuration->LOG_TYPE_DEBUG);

                return false;
            }
        }

        return $duration;
    }

    /**
     * @param $publicRequestData
     * @param $softunikSiteId
     * @param $code2char
     * @return array|bool
     * @throws Exception
     */
    protected function returnJobTypesFromPublicRequestData($publicRequestData,$softunikSiteId,$code2char){
        $jobTypes = [];
        if(isset($publicRequestData['job_types']) && !empty($publicRequestData['job_types'])){
            foreach($publicRequestData['job_types'] as $jobTypeFields){
                $jobType = null;
                if(isset($jobTypeFields["description_{$code2char}"]) && !empty(trim($jobTypeFields["description_{$code2char}"]))){
                    $jobType = trim($jobTypeFields["description_{$code2char}"]);
                }
                else{
                    $this->log("Error: The '{$code2char}' job_type '{$jobTypeFields['description']}' for Softunik public request '{$publicRequestData['id']}' from Softunik site '{$softunikSiteId}' doesn't exist.", $this->configuration->LOG_TYPE_ERROR | $this->configuration->LOG_TYPE_DEBUG);

                    return false;
                }

                if(isset($jobType) && !empty(trim($jobType))){
                    $jobTypes[] = $jobType;
                }
            }
        }

        return $jobTypes;
    }

    /**
     * @param $publicRequestData
     * @param $softunikSiteId
     * @param $code2char
     * @return bool|null
     * @throws Exception
     */
    protected function returnDeliveryDateFromPublicRequestData($publicRequestData,$softunikSiteId,$code2char){
        $deliveryDate = null;
        if(isset($publicRequestData['delivery_date']) && $publicRequestData['delivery_date'] !== '0000-00-00'){
            $deliveryDate = $publicRequestData['delivery_date'];
        }
        else{
            $deliveryDate = __('As soon as possible', 'mxo-softunik');
        }

        return $deliveryDate;
    }

    /**
     * @param $publicRequestData
     * @param $softunikSiteId
     * @param $code2char
     * @return bool|null
     * @throws Exception
     */
    protected function returnDescriptionFromPublicRequestData($publicRequestData,$softunikSiteId,$code2char){
        $description = null;
        if(isset($publicRequestData["{$code2char}_description"])){
            $description = $publicRequestData["{$code2char}_description"];
        }
        else{
            $this->log("Error: The '{$code2char}' description for Softunik public request '{$publicRequestData['id']}' from Softunik site '{$softunikSiteId}' doesn't exist.", $this->configuration->LOG_TYPE_ERROR | $this->configuration->LOG_TYPE_DEBUG);

            return false;
        }

        return $description;
    }

    /**
     * @param $publicRequestData
     * @param $softunikSiteId
     * @param $code2char
     * @return array|bool
     * @throws Exception
     */
    protected function returnAssetsFromPublicRequestData($publicRequestData,$softunikSiteId,$code2char){
        $assets = [];
        if(isset($publicRequestData['assets']) && !empty($publicRequestData['assets'])){
            foreach($publicRequestData['assets'] as $assetFields){
                $asset = null;
                if(isset($assetFields["description_{$code2char}"]) && !empty(trim($assetFields["description_{$code2char}"]))){
                    $asset = trim($assetFields["description_{$code2char}"]);
                    if(isset($assetFields['level']) && !empty(trim($assetFields['level'])) && trim($assetFields['level']) !== 'nondetermine'){
                        $asset .= ' - ' . trim($assetFields['level']);
                    }
                }
                else{
                    $this->log("Error: The '{$code2char}' asset '{$assetFields['description']}' for Softunik public request '{$publicRequestData['id']}' from Softunik site '{$softunikSiteId}' doesn't exist.", $this->configuration->LOG_TYPE_ERROR | $this->configuration->LOG_TYPE_DEBUG);

                    return false;
                }

                if(isset($asset) && !empty(trim($asset))){
                    $assets[] = $asset;
                }
            }
        }

        return $assets;
    }

    /**
     * @param $publicRequestData
     * @param $softunikSiteId
     * @param $code2char
     * @return array|bool
     * @throws Exception
     */
    protected function returnSkillsFromPublicRequestData($publicRequestData,$softunikSiteId,$code2char){
        $skills = [];
        if(isset($publicRequestData['skills']) && !empty($publicRequestData['skills'])){
            foreach($publicRequestData['skills'] as $skillFields){
                $skill = null;
                if(isset($skillFields["description_{$code2char}"]) && !empty(trim($skillFields["description_{$code2char}"]))){
                    $skill = trim($skillFields["description_{$code2char}"]);
                    if(isset($skillFields['level']) && !empty(trim($skillFields['level'])) && trim($skillFields['level']) !== 'nondetermine'){
                        $skill .= ' - ' . trim($skillFields['level']);
                    }
                }
                else{
                    $this->log("Error: The '{$code2char}' skill '{$skillFields['description']}' for Softunik public request '{$publicRequestData['id']}' from Softunik site '{$softunikSiteId}' doesn't exist.", $this->configuration->LOG_TYPE_ERROR | $this->configuration->LOG_TYPE_DEBUG);

                    return false;
                }

                if(isset($skill) && !empty(trim($skill))){
                    $skills[] = $skill;
                }
            }
        }

        return $skills;
    }

    /**
     * @param $publicRequestData
     * @return array
     */
    protected function returnDiplomasFromPublicRequestData($publicRequestData){
        $diplomas = [];
        if(isset($publicRequestData['diplomas']) && !empty($publicRequestData['diplomas'])){
            foreach($publicRequestData['diplomas'] as $diploma){
                if(isset($diploma['description']) && !empty(trim($diploma['description']))){
                    $diplomas[] = trim($diploma['description']);
                }
            }
        }

        return $diplomas;
    }

    /**
     * @param $publicRequestData
     * @return array
     */
    protected function returnWrittenLanguagesFromPublicRequestData($publicRequestData){
        $writtenLanguages = [];
        if(isset($publicRequestData['languages']) && !empty($publicRequestData['languages'])){
            foreach($publicRequestData['languages'] as $language){
                if(preg_match('#^(.+?) (?:écrit|written).*?$#i',$language['description'],$mAry)){
                    $writtenLanguage = $mAry[1];
                    if(isset($language['level']) && !empty(trim($language['level'])) && trim($language['level']) !== 'nondetermine'){
                        $writtenLanguage .= ' - ' . trim($language['level']);
                    }
                    $writtenLanguages[] = $writtenLanguage;
                }
            }
        }

        return $writtenLanguages;
    }

    /**
     * @param $publicRequestData
     * @return array
     */
    protected function returnSpokenLanguagesFromPublicRequestData($publicRequestData){
        $spokenLanguages = [];
        if(isset($publicRequestData['languages']) && !empty($publicRequestData['languages'])){
            foreach($publicRequestData['languages'] as $language){
                if(preg_match('#^(.+?) (?:parlé|spoken).*?$#i',$language['description'],$mAry)){
                    $spokenLanguage = $mAry[1];
                    if(isset($language['level']) && !empty(trim($language['level'])) && trim($language['level']) !== 'nondetermine'){
                        $spokenLanguage .= ' - ' . trim($language['level']);
                    }
                    $spokenLanguages[] = $spokenLanguage;
                }
            }
        }

        return $spokenLanguages;
    }

    protected function updateHoraireField($duration,$postId){
        if(isset($duration) && !empty(trim($duration))){
            $oldDuration = get_field('horaire',$postId,false);

            if(trim($oldDuration) !== trim($duration)){
                //update_field('field_5c5b412dssdfs20', '40 heures', $postId);
                //update_field('horaire', '40 heures', $postId);
                $mainMetaUpdateResult = update_field('horaire',trim($duration),$postId);

                if($mainMetaUpdateResult) {
                    $this->log("Updated career horaire with success.", $this->configuration->LOG_TYPE_INFO | $this->configuration->LOG_TYPE_DEBUG);
                }else{
                    $this->log("Error: Career horaire update failed.", $this->configuration->LOG_TYPE_ERROR | $this->configuration->LOG_TYPE_DEBUG);

                    return false;
                }
            }
            else{
                $this->log("Career horaire has not changed so it was not updated.", $this->configuration->LOG_TYPE_INFO | $this->configuration->LOG_TYPE_DEBUG);
            }
        }

        return true;
    }

    /**
     * @param $jobTypes
     * @param $postId
     * @return bool
     * @throws Exception
     */
    protected function updateQuartField($jobTypes,$postId){
        if(isset($jobTypes[0])) {
            $shiftField = $jobTypes[0];

            $oldShiftField = get_field('quart',$postId,false);

            if(trim($oldShiftField) !== trim($shiftField)) {
                //update_field('field_5c5b412asd120', 'Day/Jour', $postId);
                //update_field('quart', 'Day/Jour', $postId);
                $mainMetaUpdateResult = update_field('quart',$shiftField,$postId);

                if($mainMetaUpdateResult) {
                    $this->log("Updated career quart with success.", $this->configuration->LOG_TYPE_INFO | $this->configuration->LOG_TYPE_DEBUG);
                }else{
                    $this->log("Error: Career quart update failed.", $this->configuration->LOG_TYPE_ERROR | $this->configuration->LOG_TYPE_DEBUG);

                    return false;
                }
            }
            else{
                $this->log("Career quart has not changed so it was not updated.", $this->configuration->LOG_TYPE_INFO | $this->configuration->LOG_TYPE_DEBUG);
            }
        }

        return true;
    }

    /**
     * @param $jobTypes
     * @param $postId
     * @return bool
     * @throws Exception
     */
    protected function updateStatutField($jobTypes,$postId){
        if(isset($jobTypes[1])) {
            $statusField = $jobTypes[1];

            $oldStatusField = get_field('statut',$postId,false);

            if(trim($oldStatusField) !== trim($statusField)) {
                //update_field('field_5c5dfg2d82120', 'Permanent', $postId);
                //update_field('statut', 'Permanent', $postId);
                $mainMetaUpdateResult = update_field('statut',$statusField,$postId);

                if($mainMetaUpdateResult) {
                    $this->log("Updated career statut with success.", $this->configuration->LOG_TYPE_INFO | $this->configuration->LOG_TYPE_DEBUG);
                }else{
                    $this->log("Error: Career statut update failed.", $this->configuration->LOG_TYPE_ERROR | $this->configuration->LOG_TYPE_DEBUG);

                    return false;
                }
            }
            else{
                $this->log("Career statut has not changed so it was not updated.", $this->configuration->LOG_TYPE_INFO | $this->configuration->LOG_TYPE_DEBUG);
            }
        }

        return true;
    }

    /**
     * @param $deliveryDate
     * @param $postId
     * @return bool
     * @throws Exception
     */
    protected function updateEntreeField($deliveryDate,$postId){
        if(isset($deliveryDate) && !empty(trim($deliveryDate))){
            $oldDeliveryDate = get_field('entree',$postId,false);

            if(trim($oldDeliveryDate) !== trim($deliveryDate)){
                //update_field('field_5c5b41rty0','2020-03-01',$postId);
                //update_field('entree','2020-03-01',$postId);
                $mainMetaUpdateResult = update_field('entree',trim($deliveryDate),$postId);

                if($mainMetaUpdateResult) {
                    $this->log("Updated career entree with success.", $this->configuration->LOG_TYPE_INFO | $this->configuration->LOG_TYPE_DEBUG);
                }else{
                    $this->log("Error: Career entree update failed.", $this->configuration->LOG_TYPE_ERROR | $this->configuration->LOG_TYPE_DEBUG);

                    return false;
                }
            }
            else{
                $this->log("Career entree has not changed so it was not updated.", $this->configuration->LOG_TYPE_INFO | $this->configuration->LOG_TYPE_DEBUG);
            }
        }

        return true;
    }

    /**
     * @param $description
     * @param $postId
     * @return bool
     * @throws Exception
     */
    protected function updateDescriptionField($description,$postId){
        if(isset($description) && !empty(trim($description))){
            $oldDescription = get_field('description',$postId,false);

            if(trim($oldDescription) !== trim($description)){
                $mainMetaUpdateResult = update_field('description',trim($description),$postId);

                if($mainMetaUpdateResult) {
                    $this->log("Updated career description with success.", $this->configuration->LOG_TYPE_INFO | $this->configuration->LOG_TYPE_DEBUG);
                }else{
                    $this->log("Error: Career description update failed.", $this->configuration->LOG_TYPE_ERROR | $this->configuration->LOG_TYPE_DEBUG);

                    return false;
                }
            }
            else{
                $this->log("Career description has not changed so it was not updated.", $this->configuration->LOG_TYPE_INFO | $this->configuration->LOG_TYPE_DEBUG);
            }
        }

        return true;
    }

    /**
     * @param $assets
     * @param $postId
     * @return bool
     * @throws Exception
     */
    protected function updateCompetencesField($assets,$postId){
        if(!empty($assets)) {
            $assetField = '<ul>';
            foreach($assets as $asset){
                $assetField .= "<li>{$asset}</li>";
            }
            $assetField .= '</ul>';
            //$assetField = implode("&nbsp;&bull;&nbsp;",$assets);

            $oldAssetField = get_field('competences',$postId,false);

            if($oldAssetField !== $assetField) {
                //update_field('field_5c5b41ssf1a8211f', '{bullet list}/{liste de points}', $postId);
                //update_field('competences', '{bullet list}/{liste de points}', $postId);
                $mainMetaUpdateResult = update_field('competences',$assetField,$postId);

                if($mainMetaUpdateResult) {
                    $this->log("Updated career competences with success.", $this->configuration->LOG_TYPE_INFO | $this->configuration->LOG_TYPE_DEBUG);
                }else{
                    $this->log("Error: Career competences update failed.", $this->configuration->LOG_TYPE_ERROR | $this->configuration->LOG_TYPE_DEBUG);

                    return false;
                }
            }
            else{
                $this->log("Career competences has not changed so it was not updated.", $this->configuration->LOG_TYPE_INFO | $this->configuration->LOG_TYPE_DEBUG);
            }
        }

        return true;
    }

    /**
     * @param $skills
     * @param $postId
     * @return bool
     * @throws Exception
     */
    protected function updateExigencesField($skills,$postId){
        if(!empty($skills)) {
            $skillField = '<ul>';
            foreach($skills as $skill){
                $skillField .= "<li>{$skill}</li>";
            }
            $skillField .= '</ul>';
            //$skillField = implode("&nbsp;&bull;&nbsp;",$skills);

            $oldSkillField = get_field('exigences',$postId,false);

            if($oldSkillField !== $skillField) {
                //update_field('field_5c5b411a8211f', '{bullet list}/{liste de points}', $postId);
                //update_field('exigences', '{bullet list}/{liste de points}', $postId);
                $mainMetaUpdateResult = update_field('exigences', $skillField, $postId);

                if($mainMetaUpdateResult) {
                    $this->log("Updated career exigences with success.", $this->configuration->LOG_TYPE_INFO | $this->configuration->LOG_TYPE_DEBUG);
                }else{
                    $this->log("Error: Career exigences update failed.", $this->configuration->LOG_TYPE_ERROR | $this->configuration->LOG_TYPE_DEBUG);

                    return false;
                }
            }
            else{
                $this->log("Career exigences has not changed so it was not updated.", $this->configuration->LOG_TYPE_INFO | $this->configuration->LOG_TYPE_DEBUG);
            }
        }

        return true;
    }

    /**
     * @param $diplomas
     * @param $postId
     * @return bool
     * @throws Exception
     */
    protected function updateDiplomeField($diplomas,$postId){
        if(!empty($diplomas)) {
            $diploma = implode("&nbsp;&bull;&nbsp;",$diplomas);

            $oldDiploma = get_field('diplome',$postId,false);

            if(trim($oldDiploma) !== trim($diploma)) {
                //update_field('field_5c5b413582121', 'Achieved DES/DES terminé', $postId);
                //update_field('diplome', 'Achieved DES/DES terminé', $postId);
                $mainMetaUpdateResult = update_field('diplome', trim($diploma), $postId);

                if($mainMetaUpdateResult) {
                    $this->log("Updated career diplome with success.", $this->configuration->LOG_TYPE_INFO | $this->configuration->LOG_TYPE_DEBUG);
                }else{
                    $this->log("Error: Career diplome update failed.", $this->configuration->LOG_TYPE_ERROR | $this->configuration->LOG_TYPE_DEBUG);

                    return false;
                }
            }
            else{
                $this->log("Career diplome has not changed so it was not updated.", $this->configuration->LOG_TYPE_INFO | $this->configuration->LOG_TYPE_DEBUG);
            }
        }

        return true;
    }

    /**
     * @param $writtenLanguages
     * @param $postId
     * @return bool
     * @throws Exception
     */
    protected function updateLanguesEcritesField($writtenLanguages,$postId){
        if(!empty($writtenLanguages)) {
            //$writtenLanguageField = '<ul>';
            //foreach($writtenLanguages as $writtenLanguage){
            //    $writtenLanguageField .= "<li>{$writtenLanguage}</li>";
            //}
            //$writtenLanguageField .= '<ul>';
            $writtenLanguageField = implode("&nbsp;&bull;&nbsp;",$writtenLanguages);

            $oldWrittenLanguageField = get_field('langues_ecrites',$postId,false);

            if($oldWrittenLanguageField !== $writtenLanguageField) {
                //update_field('field_5c5b414982123', 'french/français', $postId);
                //update_field('langues_ecrites', 'french/français', $postId)
                $mainMetaUpdateResult = update_field('langues_ecrites', $writtenLanguageField, $postId);

                if($mainMetaUpdateResult) {
                    $this->log("Updated career langues_ecrites with success.", $this->configuration->LOG_TYPE_INFO | $this->configuration->LOG_TYPE_DEBUG);
                }else{
                    $this->log("Error: Career langues_ecrites update failed.", $this->configuration->LOG_TYPE_ERROR | $this->configuration->LOG_TYPE_DEBUG);

                    return false;
                }
            }
            else{
                $this->log("Career langues_ecrites has not changed so it was not updated.", $this->configuration->LOG_TYPE_INFO | $this->configuration->LOG_TYPE_DEBUG);
            }
        }

        return true;
    }

    /**
     * @param $spokenLanguages
     * @param $postId
     * @return bool
     * @throws Exception
     */
    protected function updateLanguesParleesField($spokenLanguages,$postId){
        if(!empty($spokenLanguages)) {
            //$spokenLanguageField = '<ul>';
            //foreach($spokenLanguages as $spokenLanguage){
            //    $spokenLanguageField .= "<li>{$spokenLanguage}</li>";
            //}
            //$spokenLanguageField .= '<ul>';
            $spokenLanguageField = implode("&nbsp;&bull;&nbsp;",$spokenLanguages);

            $oldSpokenLanguageField = get_field('langues_parlees',$postId,false);

            if($oldSpokenLanguageField !== $spokenLanguageField) {
                //update_field('field_5c5b414982123', 'french/français', $postId);
                //update_field('langues_parlees', 'french/français', $postId)
                $mainMetaUpdateResult = update_field('langues_parlees', $spokenLanguageField, $postId);

                if($mainMetaUpdateResult) {
                    $this->log("Updated career langues_parlees with success.", $this->configuration->LOG_TYPE_INFO | $this->configuration->LOG_TYPE_DEBUG);
                }else{
                    $this->log("Error: Career langues_parlees update failed.", $this->configuration->LOG_TYPE_ERROR | $this->configuration->LOG_TYPE_DEBUG);

                    return false;
                }
            }
            else{
                $this->log("Career langues_parlees has not changed so it was not updated.", $this->configuration->LOG_TYPE_INFO | $this->configuration->LOG_TYPE_DEBUG);
            }
        }

        return true;
    }

    protected function retrieveAPIHelper()
    {
        if (!isset($this->APIHelper)) {
            $this->APIHelper = new APIHelper(
                $this->configuration->SOFTUNIK_API->id,
                $this->configuration->SOFTUNIK_API->secret,
                $this->configuration->SOFTUNIK_API->code
            );
        }

        return $this->APIHelper;
    }
}