<?php
/**
 * Author: Dev Mxo <dev@agencemxo.com>, Stéphane Cloutier <stephane.cloutier@agencemxo.com>
 * License: MXO Copyright, exclusive usage.
 */

namespace MxoSoftunikPlugin\Front\Site;

/**
 * Class EntryFormSoftunikValidationException
 * @package MxoSoftunikPlugin\Front\Site
 */
class EntryFormSoftunikValidationException extends \Exception
{
    /** @var mixed|string */
    protected $clientMessage;

    /**
     * EntryFormSoftunikValidationException constructor.
     * @param string $message
     * @param string $clientMessage
     * @param int $code
     * @param null $previous
     */
    public function __construct($message = "", $clientMessage = "", $code = 0, $previous = null)
    {
        parent::__construct($message, $code, $previous);
        $this->clientMessage = $clientMessage;
    }

    /**
     * @return mixed|string
     */
    public function getClientMessage()
    {
        return $this->clientMessage;
    }
}
