<?php
/**
 * Author: Dev Mxo <dev@agencemxo.com>, Stéphane Cloutier <stephane.cloutier@agencemxo.com>
 * License: MXO Copyright, exclusive usage.
 */

namespace MxoSoftunikPlugin\Front\Site;

/**
 * Class EntryFormSoftunikValidationFieldException
 * @package MxoSoftunikPlugin\Front\Site
 */
class EntryFormSoftunikValidationFieldException extends \Exception
{
    /** @var mixed */
    protected $field;

    /** @var mixed|string */
    protected $clientMessage;

    /**
     * EntryFormSoftunikValidationFieldException constructor.
     * @param $field
     * @param string $message
     * @param string $clientMessage
     * @param int $code
     * @param null $previous
     */
    public function __construct($field, $message = "", $clientMessage = "", $code = 0, $previous = null)
    {
        parent::__construct($message, $code, $previous);
        $this->field = $field;
        $this->clientMessage = $clientMessage;
    }

    /**
     * @return mixed
     * @noinspection PhpUnused
     */
    public function getField()
    {
        return $this->field;
    }

    /**
     * @return mixed|string
     */
    public function getClientMessage()
    {
        return $this->clientMessage;
    }
}
