<?php
/**
 * Plugin Name: Mxo Softunik
 * Text Domain: mxo-softunik
 * Domain Path: /i18n
 */

/**
 * Class MxoSoftunikPlugin
 */
class MxoSoftunikPlugin
{
    /** @var MxoSoftunikPlugin */
    protected static $singleton;

    /** @var bool */
    protected $built = false;

    /** @var bool */
    protected $initialized = false;

    /** @var string */
    protected $path;

    /** @var string */
    protected $file;

    /**
     * MxoSoftunikPlugin constructor.
     */
    protected function __construct()
    {
        $this->file = __FILE__;
        $this->path = dirname(__FILE__);
    }

    /**
     * @return string
     */
    public function getPath()
    {
        return $this->path;
    }

    /**
     * @return string
     */
    public static function returnPath()
    {
        $obj = self::singleton();

        return $obj->getPath();
    }

    /**
     * @return string
     */
    public function getFile()
    {
        return $this->file;
    }

    /**
     * @return string
     * @noinspection PhpUnused
     */
    public static function returnFile()
    {
        $obj = self::singleton();

        return $obj->getFile();
    }

    /**
     * @return MxoSoftunikPlugin
     */
    public static function singleton()
    {
        if (!isset(self::$singleton)) {
            self::$singleton = new self();
        }

        return self::$singleton;
    }

    /**
     *
     */
    protected function build()
    {
        if (!$this->built) {
            $this->built = true;
            $file = $this->path . '/vendor/autoload.php';
            if (is_file($file)) {
                /** @noinspection PhpIncludeInspection */
                require($file);
            } else {
                spl_autoload_register(array($this, 'autoload'), true, true);
            }
        }
    }

    /**
     * @param $className
     */
    public function autoload($className)
    {
        if (strpos($className, __CLASS__ . '\\') === 0) {
            $file = $this->path . '/classes/' . str_replace('\\', '/', substr($className, strlen(__CLASS__ . '\\'))) . '.php';
            if (is_file($file)) {
                /** @noinspection PhpIncludeInspection */
                require($file);
            }
        }
    }

    /**
     *
     */
    public function initialize()
    {
        if (!$this->initialized) {
            $this->initialized = true;

            $this->build();

            $this->admin_pages();

            $this->front_entry_form_validations();
        }
    }

    /**
     *
     */
    public function admin_pages()
    {
        if (is_admin()) {
            add_action('init', [\MxoSoftunikPlugin\Admin\Site\SyncPage::class, 'initialize']);
        }
    }

    /**
     *
     */
    public function front_entry_form_validations()
    {
        if (!is_admin()) {
            add_filter('gform_validation', [\MxoSoftunikPlugin\Front\Site\EntryFormSoftunikValidation::class, 'process']);
        }
    }
}

$MxoSoftunikPlugin = MxoSoftunikPlugin::singleton();
$MxoSoftunikPlugin->initialize();
