<?php
/**
 * Command: custom:mxo-softunik:sync
 * Description: Fetches careers data from Softunik account and imports it into Wordpress custom post type 'carrieres-prograin'.
 * Author: Dev Mxo <dev@agencemxo.com>, Stéphane Cloutier <stephane.cloutier@agencemxo.com>
 * License: MXO Copyright, exclusive usage.
 */

if (!defined('WP_CLI')) {
    exit;
}

$pluginDirectory = dirname(dirname(dirname(__FILE__)));
$configurationRepository = $pluginDirectory . '/wp-cli/configurations';
$commandName = 'custom:' . basename($pluginDirectory) . '-plugin:' . basename(__FILE__,'.php');
$commandBasename = str_replace(':','.',$commandName);

if(php_sapi_name() === 'cli'){
    /**
     * Fetches careers data from Softunik account and imports it into Wordpress custom post type 'carrieres-prograin'.
     *
     * ## EXAMPLES
     *
     *     wp custom:mxo-softunik:sync
     */
    \WP_CLI::add_command(
        $commandName,
        array(
            new \MxoSoftunikPlugin\Command\Sync(
                $commandBasename,
                new \MxoWPCLI\Configuration(
                    $configurationRepository . '/commands/' . basename(__FILE__),
                    array(
                        $configurationRepository . '/softunik.php'
                    )
                )
            ),
            'execute',
        ),
        array(
            'shortdesc'=>"Fetches careers data from Softunik account and imports it into Wordpress custom post type 'carrieres-prograin'.",
        )
    );
}