<?php
// Custom post type proudly generated by wp_console

    

add_action('rest_api_init', function () {
    $fields = array('utm','mr');
    foreach($fields as $field) {
        register_rest_field( 'semence-prograin',
           $field,
           array(
              'get_callback'    => function ( $object, $field_name, $request ) {
                  return get_post_meta( $object[ 'id' ], $field_name , true);
              },
              'schema' => null,
           )
        );
    }

});


register_post_type('semence-prograin',
    [
        'labels' => [
            'name' => __('Seeds & Soybeans', 'prograin'),
            'singular_name' => __('Seeds & Soybeans', 'prograin'),
        ],
        'supports' => array('title', 'excerpt'),
        'public' => true,
        'has_archive' => false,
        'menu_icon' => 'dashicons-soya',
        'show_in_rest' => true,
        'rewrite' => array(
            'slug' => 'seed'
        )
    ]);

    add_rewrite_rule('^soya/(.+)/?', 'index.php?semence-prograin=$matches[1]&soya=1', 'top');
    add_rewrite_rule('^soy/(.+)/?', 'index.php?semence-prograin=$matches[1]&soya=1', 'top');
    add_rewrite_rule('^semence/(.+)/?', 'index.php?semence-prograin=$matches[1]', 'top');
    add_rewrite_rule('^.+/soya/(.+)/?', 'index.php?semence-prograin=$matches[1]&soya=1', 'top');
    add_rewrite_rule('^.+/soy/(.+)/?', 'index.php?semence-prograin=$matches[1]&soya=1', 'top');
    add_rewrite_rule('^.+/semence/(.+)/?', 'index.php?semence-prograin=$matches[1]', 'top');
    
    
    add_filter('query_vars', function ($vars) {
        $vars[] = 'soya';
        return array_unique($vars);
    }, 10, 1);  
 