<?php

add_shortcode('carriere', function ($atts) {

    $posts_array = get_posts(array( 
        'post_type' => 'carrieres-prograin',
        'posts_per_page' => -1,  
        'suppress_filters' => false,
        'tax_query' =>array(
            'relation' => 'AND',
            array(
                'taxonomy' => 'carrieres-cat',
                'field' => 'term_id',
                'terms' => $atts['type'],
            )
        )
    ));
    $posts = array_map(function ($post) {
        return new \Balise\AnchorFramework\PostWrapper($post, true);
    }, $posts_array);

    return \Balise\AnchorFramework\Anchor::Render('carrieres-prograin.list', array(
        "posts" => $posts,
    ));


});

add_action('admin_head', function(){
    ?><script>window.currentSite = '<?= get_site_url(); ?>' </script><?php
});