<?php

function frenchFormatingFunction($string) {
    if (substr(get_locale(),0,2)==="fr") {
        // Espace et 2 points
        $string = preg_replace('/(\w)(\s+:)\xc2\xa0/', '${1}&nbsp;: ', $string);
        $string = preg_replace('/(\w)(\s+:)&nbsp;/', '${1}&nbsp;: ', $string);
        $string = preg_replace('/(\w)(\h+:)(\s|\r|\n|<)/', '${1}&nbsp;:${3}', $string);

        // Chevrons
    
        $string = str_replace('&#187;', '»', $string);
        $string = str_replace('&#171;', '«', $string);
        $string = str_replace('&raquo;', '»', $string);
        $string = str_replace('&laquo;', '«', $string);

        $string = preg_replace('/\s+\»|\»/', '&nbsp;&#187;', $string);
        $string = preg_replace('/\«|\«\s+/', "&#171;&nbsp;", $string); 
        $string = preg_replace('/\&nbsp\;\s+/', "&nbsp;", $string); 
        $string = str_replace('»','&#187;', $string);
        $string = str_replace('«','&#171;', $string);

        // Pourcentage
        $string = preg_replace('/(\d)\s?\%/', '${1}&nbsp;%', $string);
    }
    return $string;
}
add_filter( 'the_content', 'frenchFormatingFunction');
