<?php
// Setup Models
namespace Prograin;

use Illuminate\Database\Capsule\Manager as Capsule;
use Illuminate\Support\Str;

class ParcellesModel extends \Illuminate\Database\Eloquent\Model {
     static function _registerModels() {
        global $wpdb;
        include_once(ABSPATH.'wp-admin/includes/plugin.php');

        $capsule = new Capsule;


        $capsule->addConnection([
            'driver'    => 'mysql',
            'host'      => $_ENV['RESULTATS_HOST'],
            'database'  => $_ENV['RESULTATS_NAME'],
            'username'  => $_ENV['RESULTATS_USER'],
            'password'  => $_ENV['RESULTATS_PASSWORD'],
            'charset'   => DB_CHARSET,
            'collation' => ((DB_COLLATE) ? DB_COLLATE : NULL),
        ]);

        // Make this Capsule instance available globally via static methods
        $capsule->setAsGlobal();

        // Setup the Eloquent ORM
        $capsule->bootEloquent();
    }
}
ParcellesModel::_registerModels();

require_once(dirname(__DIR__).'/models/cie.php');
require_once(dirname(__DIR__).'/models/culture.php');
require_once(dirname(__DIR__).'/models/espacements.php');
require_once(dirname(__DIR__).'/models/parcelles.php');
require_once(dirname(__DIR__).'/models/producteurs.php');
require_once(dirname(__DIR__).'/models/resultats.php');
require_once(dirname(__DIR__).'/models/secteurs.php');
require_once(dirname(__DIR__).'/models/traitements.php');
require_once(dirname(__DIR__).'/models/travailSol.php');
require_once(dirname(__DIR__).'/models/types.php');
require_once(dirname(__DIR__).'/models/typeSol.php');
require_once(dirname(__DIR__).'/models/varietes.php');


