<?php

add_shortcode('soyalist', function ($atts) {

    $soycat = get_terms('soyas_categories', array(
        'hide_empty' => false,
        'meta_query' => array(
            [
                'key' => 'ogm',
                'value' => 1,
                'compare' => '=',
            ],
        ),
    ));
    $biocat = get_terms('soyas_categories', array(
        'hide_empty' => false,
        'meta_query' => array(
            [
                'key' => 'bio',
                'value' => 1,
                'compare' => '=',
            ],
        ),
    ));
    if (gettype($soycat) !== "array") {
        $soycat = array();
    }
    if (gettype($biocat) !== "array") {
        $biocat = array();
    }

    if (!@isset($atts) || gettype($atts) !== "array") {
        $atts = array();
    }

    $ogm_cats = array_map(function ($i) {return $i->term_id;}, $soycat);
    $bio_cats = array_map(function ($i) {return $i->term_id;}, $biocat);

    if (in_array('ogm', $atts)) {
        $operator = 'IN';
        $cat = $ogm_cats;
    } elseif (in_array('noogm', $atts)) {
        $operator = 'NOT IN';
        $cat = $ogm_cats;
    } elseif (in_array('bio', $atts)) {
        $operator = 'IN';
        $cat = $bio_cats;
    } elseif (in_array('nonbio', $atts)) {
        $operator = 'NOT IN';
        $cat = array_merge($bio_cats,$ogm_cats);
    }

    $posts_array = get_posts(array( 
        'post_type' => 'semence-prograin',
        'posts_per_page' => -1,  
        'suppress_filters' => false,
        'tax_query' => isset($operator) ? array(
            'relation' => 'AND',
            array(
                'taxonomy' => 'soyas_utilisations',
                'operator' => 'EXISTS',
            ),
            array(
                'taxonomy' => 'soyas_categories',
                'field' => 'term_id',
                'terms' => $cat,
                'operator' => $operator,
            )
        ) : array(
            array(
                'taxonomy' => 'soyas_utilisations',
                'operator' => 'EXISTS',
            ),
        ),
    ));
    $posts = array_map(function ($post) {
        return new \Balise\AnchorFramework\PostWrapper($post, true);
    }, $posts_array);

    return \Balise\AnchorFramework\Anchor::Render('soya.list', array(
        "posts" => $posts,
    ));


});
