<?php


add_action('save_post',function ($post_id) {
    if (get_post_type($post_id)==='semence-prograin') {
        remove_action('save_post','update_fichier');
        $langs = array('en','fr');
        $fields = array(
            'grain_height',
            'grain_width',
            'comp_proteine',
            'comp_huile',
            'comp_sucre_total',
            'suchrose',
            'comp_stachyose',
            'moisture',
            'seed_color',
            'oil_color',
            'weight_hundred_seeds',
            'hunterlab_color',
            'soak_sample_weight',
            'soak_dry_matter_dm',
            'soak_water_uptake_factor_dm',
            'soak_water_uptake_asis',
            'tofu_yeild_protein',
            'tofu_yeild_dm',
            'tofu_boiling_test',
            'tofu_lab',
            'brevage_lab',
            'brevage_brix',
            'image_grain',
            'image',
            'biologique',
            'utm',
            'mr',
            'car_agro_adaptation_semis_30_po',
            'car_gene_resistance_nematode_kyste_soya',
            'car_gene_resistance_phytophora',
            'car_teneur_proteine',
            'car_nombre_grains_kg',
            'car_agro_vigueur_semis_direct',
            'car_agro_stabilite_adaptabilite',
            'car_agro_tolerance_sclerotinia',
            'car_agro_tenue',
            'nb_grains_m_7_po',
            'nb_grains_m_14_po',
            'nb_grains_m_30_po',
            'taux_semis_7_po',
            'taux_semis_14_po',
            'taux_semis_30_po',
            'nb_grains_ha_7_po',
            'nb_grains_ha_14_po',
            'nb_grains_ha_30_po',
            'carmataribuzin'
        );
        foreach($langs as $lang) {
            
            $lid = pll_get_post($post_id, $lang);
            foreach($fields as $field) {
                $data = get_field($field,$post_id,false);
                if ($field !== 'mr') {
                    if ($lang === "fr") {
                        $data = preg_replace('/(\d)\.(\d)/','\1,\2',$data);
                    }
                    if ($lang === "en") {
                        $data = preg_replace('/(\d),(\d)/','\1.\2',$data);
                    }
                }
                update_field($field,$data,$lid);
            }
        }

        add_action('save_post','update_fichier');

    }
}); 