import Vue from "vue";
import Semences from "./vue/semences-liste.vue";
import Soya from "./vue/soya-liste.vue";
import Resultats from "./vue/resultats-parcelle.vue";
import Distributeurs from "./vue/distributeurs.vue";
import classlistPolyfill from 'classlist-polyfill';

require("./polyfill")();


window.initMap = require("./map/map.js");

window.setCookie = function (cname, cvalue, exdays) {
    var d = new Date();
    d.setTime(d.getTime() + (exdays * 24 * 60 * 60 * 1000));
    var expires = "expires=" + d.toUTCString();
    document.cookie = cname + "=" + cvalue + ";" + expires + ";path=/";
}

window.getCookie = function (cname) {
    var name = cname + "=";
    var ca = document.cookie.split(';');
    for (var i = 0; i < ca.length; i++) {
        var c = ca[i];
        while (c.charAt(0) == ' ') {
            c = c.substring(1);
        }
        if (c.indexOf(name) == 0) {
            return c.substring(name.length, c.length);
        }
    }
    return "";
}

//START Landing JS

const landingNav = document.querySelector('.landing-nav');

if(landingNav) {
    const landingBurger = document.querySelector('.landing-nav__close');

    landingBurger.addEventListener('click', () => {
        landingNav.classList.toggle('landing-nav--active')
    })
}

let prevScrollpos = window.pageYOffset;
window.onscroll = function() {
    let currentScrollPos = window.pageYOffset;
    let nav = document.getElementById("landing-nav");
    nav.style.top = prevScrollpos > currentScrollPos ? "0" : `-${nav.offsetHeight + 10 }px`;
    prevScrollpos = currentScrollPos;
}

//END Landing JS

document.querySelectorAll('.distributeur-liste').forEach(list => {
    let items = [];
    list.querySelectorAll('.distributeur-item').forEach(item => {
        items.push({
            html: item.innerHTML,
            id: item.dataset.id,
            ville: item.dataset.ville,
            lat: parseFloat(item.dataset.lat),
            lng: parseFloat(item.dataset.lng),
            url: item.dataset.href || false,
        })
    })
    new Vue({
        template: '<Distributeurs v-bind:items="elements" v-bind:translations="translations" />',
        components: {
            Distributeurs
        },
        data: {
            elements: items,
            translations: {
                search: "Recherche",
                utm: "UTM",
                utmSort: "Trier par UTM",
                filters: "Filtres",
                noresults: "Aucune semence ne correspond à votre recherche. "
            }
        },
        el: list
    })
});

document.querySelectorAll('.semence-archive').forEach(list => {
    let items = [];
    list.querySelectorAll('.semence-archive-item').forEach(item => {
        let terms = []
        item.querySelectorAll(".terms span").forEach(a => {
            terms.push(a.innerText)
        })
        items.push({
            html: item.innerHTML,
            nom: item.querySelector("h2").innerText,
            excerpt: item.querySelector(".excerpt").innerText,
            utm: parseFloat(item.querySelector(".utm-data").innerText.replace(" ", "")),
            mr: item.querySelector(".mr-data").innerText,
            terms: terms,
        })
    })
    items.forEach(item => {
        item.strsearch = item.nom + " " + item.excerpt + " " + item.terms.join(" ");
        item.strsearch = item.strsearch.toLowerCase()
    })
    new Vue({
        template: '<Semences v-bind:items="elements" />',
        components: {
            Semences
        },
        data: {
            elements: items
        },
        el: list
    })
});

document.querySelectorAll('.soya-archive').forEach(list => {
    let items = [];
    list.querySelectorAll('.soya-archive-item').forEach(item => {
        let terms = []
        item.querySelectorAll(".goodfor span").forEach(a => {
            terms.push(a.innerText)
        })
        items.push({
            html: item.innerHTML,
            nom: item.querySelector("h2").innerText,
            protein: parseFloat(item.querySelector(".protein-data").innerText.replace(" ", "")),
            terms: terms,
        })
    })
    items.forEach(item => {
        item.strsearch = item.nom + " " + item.excerpt + " " + item.terms.join(" ");
        item.strsearch = item.strsearch.toLowerCase()
    })
    new Vue({
        template: '<Soya v-bind:items="elements" v-bind:translations="translations" />',
        components: {
            Soya
        },
        data: {
            elements: items,
            translations: {
                filters: "Filtres",

                noresults: "Aucun soya ne correspond à votre recherche. "
            }
        },
        el: list
    })
});

document.querySelectorAll('.resultatsparcelle').forEach(list => {
    new Vue({
        template: '<Resultats v-bind:items="elements" v-bind:translations="translations" />',
        components: {
            Resultats
        },
        data: {
            elements: window.parcelleData,
            translations: {
                search: "Recherche",
                utm: "UTM",
                utmSort: "Trier par UTM",
                filters: "Filtres",
                adresse: "Adresse",
                province: "Province",
                ville: "Ville",
                distributeur: "Distributeur",
                representant: "Representant",
                longlat: "Longitude Latitude",
                lang: "fr",
                noresults: "Aucune parcelle ne correspond à votre recherche. "
            }
        },
        el: list
    })
})

let espclient = document.querySelector('nav .inside>div:last-child>ul>li:last-child')
if (document.querySelector('footer .espaceclient')) {
    espclient.innerHTML += document.querySelector('footer .espaceclient').innerHTML
}



document.querySelectorAll('nav ul a').forEach(link => {
    if (link.querySelector('img')) {
        let c = link.querySelector('img').cloneNode()
        document.querySelector('nav').appendChild(c)
        link.addEventListener('mouseenter', () => {
            document.querySelectorAll('nav img.active').forEach(img => {
                img.classList.remove("active")
            })
            c.classList.add("active")
        })
    }
});



window._ = function (el) {
    if (!(this instanceof _)) {
        return new _(el);
    }
    this.el = document.getElementById(el);
}

window._.prototype.fade = function fade(type, ms) {
    var isIn = type === 'in',
        opacity = isIn ? 0 : 1,
        interval = 50,
        duration = ms,
        gap = interval / duration,
        self = this;

    if (isIn) {
        self.el.style.display = 'inline';
        self.el.style.opacity = opacity;
    }

    function func() {
        opacity = isIn ? opacity + gap : opacity - gap;
        self.el.style.opacity = opacity;

        if (opacity <= 0) self.el.style.display = 'none'
        if (opacity <= 0 || opacity >= 1) {
            window.clearInterval(fading);
        }
    }

    var fading = window.setInterval(func, interval);
}

var homevideo = document.getElementById("homevideoiframe")
if (homevideo && !getCookie('homevideoplayed')) {
    setCookie('homevideoplayed', 1, 1)
    var player = new Vimeo.Player(homevideo);

    player.on('ended', function () {
        _('homescreenvideo').fade('out', 500);
        player.setVolume(0)
    });
    document.getElementById("homevideoskip").addEventListener('click', function (e) {
        _('homescreenvideo').fade('out', 500);
        player.setVolume(0)
        e.preventDefault();
    })
    document.getElementById("hometogglerestart").addEventListener("click", function () {
        player.setCurrentTime(0)
    })
} else if (document.getElementById("homescreenvideo")) {
    document.getElementById("homescreenvideo").remove()
}


window.document.querySelectorAll("select").forEach(sel => {
    if (sel.value === "") sel.classList.add("placeholder")
    else sel.classList.remove("placeholder")
    sel.addEventListener("change", () => {
        if (sel.value === "") sel.classList.add("placeholder")
        else sel.classList.remove("placeholder")
    })
})

window.document.body.addEventListener("click", (e) => {
    let path = event.path || (event.composedPath && event.composedPath());
    if (path) {
        const linkTarget = path.filter(el => (el.matches && el.matches("a")))[0];

        if (linkTarget) {
            var url = linkTarget.href + ""
            var selfurl = window.location.protocol + '//' + window.location.host + window.location.pathname + "#";
            if (url.substr(0, selfurl.length) === selfurl) {
                url = '#' + url.substr(selfurl.length);
            }
            selfurl = window.location.protocol + '//' + window.location.host + window.location.pathname

            if (url === "#" || url === selfurl || url === selfurl + '/') {
                //   $("body, html").animate({scrollTop: 0}, '500');
                e.preventDefault();
                e.stopPropagation();
            } else if (url.substring(0, 1) == "#") {
                var hashTarget = document.querySelector(url);
                hashTarget = hashTarget ? hashTarget : document.querySelector('[name=' + url.slice(1) + ']');
                if (hashTarget) {
                    var newtop = window.scrollY + hashTarget.getBoundingClientRect().top - 90;
                    scrollIt(newtop);
                    return false;
                }
                e.preventDefault();
                e.stopPropagation();
            } else if (url.substring(0, 7) == "http://" || url.substring(0, 8) == "https://") {
                var a = new RegExp(window.location.host);
                if (!a.test(url)) {
                    window.open(this.href, '_blank');

                    e.preventDefault();
                    e.stopPropagation();
                }
            }
        }
    }
})


function AjustMenuTeam() {
    let current = null;

    document.querySelectorAll(".team-group").forEach(i => {
        if (current === null) {
            current = i;
        }
        if (current.getBoundingClientRect().top < i.getBoundingClientRect().top && i.getBoundingClientRect().top < window.innerHeight) {
            current = i
        }

    })
    if (current) {
        document.querySelectorAll('.team-menu a').forEach(el => {
            el.classList.remove("active")
        })
        document.querySelector('.team-menu a[href="#' + current.id + '"]').classList.add("active")
    }
}
window.addEventListener("resize", AjustMenuTeam)
window.addEventListener("load", AjustMenuTeam)
window.addEventListener("scroll", AjustMenuTeam)


function scrollIt(destination, duration = 200, easing = 'linear', callback) {

    const easings = {
        linear(t) {
            return t;
        },
        easeInQuad(t) {
            return t * t;
        },
        easeOutQuad(t) {
            return t * (2 - t);
        },
        easeInOutQuad(t) {
            return t < 0.5 ? 2 * t * t : -1 + (4 - 2 * t) * t;
        },
        easeInCubic(t) {
            return t * t * t;
        },
        easeOutCubic(t) {
            return (--t) * t * t + 1;
        },
        easeInOutCubic(t) {
            return t < 0.5 ? 4 * t * t * t : (t - 1) * (2 * t - 2) * (2 * t - 2) + 1;
        },
        easeInQuart(t) {
            return t * t * t * t;
        },
        easeOutQuart(t) {
            return 1 - (--t) * t * t * t;
        },
        easeInOutQuart(t) {
            return t < 0.5 ? 8 * t * t * t * t : 1 - 8 * (--t) * t * t * t;
        },
        easeInQuint(t) {
            return t * t * t * t * t;
        },
        easeOutQuint(t) {
            return 1 + (--t) * t * t * t * t;
        },
        easeInOutQuint(t) {
            return t < 0.5 ? 16 * t * t * t * t * t : 1 + 16 * (--t) * t * t * t * t;
        }
    };

    const start = window.pageYOffset;
    const startTime = 'now' in window.performance ? performance.now() : new Date().getTime();

    const documentHeight = Math.max(document.body.scrollHeight, document.body.offsetHeight, document.documentElement.clientHeight, document.documentElement.scrollHeight, document.documentElement.offsetHeight);
    const windowHeight = window.innerHeight || document.documentElement.clientHeight || document.getElementsByTagName('body')[0].clientHeight;
    const destinationOffset = typeof destination === 'number' ? destination : destination.offsetTop;
    const destinationOffsetToScroll = Math.round(documentHeight - destinationOffset < windowHeight ? documentHeight - windowHeight : destinationOffset);

    if ('requestAnimationFrame' in window === false) {
        window.scroll(0, destinationOffsetToScroll);
        if (callback) {
            callback();
        }
        return;
    }

    function scroll() {
        const now = 'now' in window.performance ? performance.now() : new Date().getTime();
        const time = Math.min(1, ((now - startTime) / duration));
        const timeFunction = easings[easing](time);
        window.scroll(0, Math.ceil((timeFunction * (destinationOffsetToScroll - start)) + start));

        if (window.pageYOffset === destinationOffsetToScroll) {
            if (callback) {
                callback();
            }
            return;
        }

        requestAnimationFrame(scroll);
    }

    scroll();
}


//OLD
// document.querySelector("aside .switchlang").addEventListener("click", () => {
//     window.location = "/?switch=1&l=" + document.documentElement.lang;
// })
// if (document.querySelector("aside .switchlang")) {
//     document.querySelector("nav .switchlang").addEventListener("click", () => {
//         window.location = "/?switch=1&l=" + document.documentElement.lang;
//     })
//
// }

//NEW ADD check condition
const aside = document.querySelector("aside .switchlang");
if(aside) {
    aside.addEventListener("click", () => {
        window.location = "/?switch=1&l=" + document.documentElement.lang;
    })
    document.querySelector("nav .switchlang").addEventListener("click", () => {
        window.location = "/?switch=1&l=" + document.documentElement.lang;
    })
}





if (!document.documentElement.classList.contains("cssgrid")) {

    
    let totalBlock = document.querySelectorAll("nav ul.menu>li.menu-item ").length;
    let smallBlock = document.querySelectorAll("nav ul.menu>li.menu-item.small").length;

    let rows = Math.ceil((totalBlock)/2);

    if (smallBlock > 1) rows = Math.ceil((totalBlock-1)/2);
    console.log(rows)


    var style = document.createElement("style");
    document.head.appendChild(style);
    
    style.innerHTML = `
@media (min-width: 64pc) {
    nav ul.menu {
        display: block !important;
    }
    nav ul.menu>li.menu-item {
        width: ${100/rows}% !important;
        float: left;
        padding-left: 4.5% !important;
        padding-top: 2% !important;
        height: 50%;
        
    }
    nav ul.menu>li.menu-item:nth-child(2) {
        padding-top: 75pt !important;
    }
    nav ul.menu>li.menu-item:last-child {
        padding-top: 0 !important;
        padding-left: 0 !important;
    }
    nav ul.menu>li.menu-item:last-child>* {
        padding-left: 13.5% !important;
    }
}
    `

}
