module.exports = function () {
   
    let distMap = document.querySelector(".distributeur-map .map");
    if (distMap) {

        let map = new google.maps.Map(distMap, {
            center: {
                lat: parseFloat(distMap.dataset.lat),
                lng: parseFloat(distMap.dataset.lng)
            },
            zoom: 9,
            styles: require('./mapStyle.json'),
            disableDefaultUI: true
        });
        window.map = map;
        var infowindow = new google.maps.InfoWindow({

          });
        
        let AllMarkers = [];
        window.rebuildMarkers = () => {
            AllMarkers.forEach(i => {
                i.setMap(null)
            })
            AllMarkers = [];
            window.AllMarkers = {}
            document.querySelectorAll(".distributeur-item").forEach(dist => {
                if (dist.dataset.lat && dist.dataset.lng) {
                    
                    var marker = new google.maps.Marker({ 
                        map: map,
                        position: {
                            lat: parseFloat(dist.dataset.lat), 
                            lng: parseFloat(dist.dataset.lng)
                        },
                        icon: window.template_url+"/public/images/icone-map.png",
                    });
                    let html = dist.innerHTML;
                    marker.addListener('click', () => {
                        infowindow.open(map, marker);
                        infowindow.setContent('<div class="dist-infowindow">'+html+"</div>")
                      });
                    AllMarkers.push(marker);
                    window.AllMarkers[dist.dataset.id] = marker;

                }
            })
        }
        window.rebuildMarkers();


    }






    let contactMap = document.querySelector(".contact-map .map");
    if (contactMap) {
        new google.maps.Marker({
            map: new google.maps.Map(contactMap, {
                center: {
                    lat: parseFloat(contactMap.getAttribute("data-lat")),
                lng: parseFloat(contactMap.getAttribute("data-lng"))
                },
                zoom: 10,
                styles: require('./mapStyle.json'),
                disableDefaultUI: true
            }),
            position:{
                
                lat: parseFloat(contactMap.getAttribute("data-lat")),
                lng: parseFloat(contactMap.getAttribute("data-lng"))
            },
            icon: window.template_url+"/public/images/icone-map.png",
            title: 'Hello World!'
        });
        
        }


    
    // Create a map object and specify the DOM element
    // for display.


   
    
    //distribuer l'événement.
    if (window.parcellesLoad) window.parcellesLoad()
    if (window.distLoad) window.distLoad()


}