<?php
namespace Prograin;

class Parcelle extends ParcellesModel
{
    protected $primaryKey = "parcelle_id";
    protected $table = "t_parcelles";
    protected $hidden = [
        'valide_par',
        'date_enregistrement',
        'date_publication',
        'remarque',
        'remarque_en',
        'updated_at',
        'created_at',
        'traitement_id',
        'variete_id'
    ];

    public function variete()
    {
        return $this->belongsTo('Prograin\Variete', 'variete_id');
    }
    
    public function secteur()
    {
        return $this->belongsTo('Prograin\Secteur', 'secteur_id');
    }
    public function traitement()
    {
        return $this->belongsTo('Prograin\Traitement', 'traitement_id');
    }
    public function resultat()
    {
        return $this->belongsTo('Prograin\Resultat', 'resultat_id');
    }
}
