<?php
namespace Prograin;

class Resultat extends ParcellesModel
{
    protected $primaryKey = "resultat_id";
    protected $table = "t_resultats";





    public function producteur() {
        return $this->belongsTo('Prograin\Producteur', 'producteur_id');
    }
    
    public function travail_sol() {
        return $this->belongsTo('Prograin\TravailAuSol', 'travail_au_sol_id');
    }

    public function type_sol() {
        return $this->belongsTo('Prograin\TypeDeSol', 'type_de_sol');
    }
    public function espacement() {
        return $this->belongsTo('Prograin\Espacement', 'espacement_id');
    }

    public function c_precedente() {
        return $this->belongsTo('Prograin\Culture', 'culture_precedente_id');
    }

     

    public function parcelles() {
        return $this->hasMany('Prograin\Parcelle', 'resultat_id'); 
    }
}
