{{-- Template name: Distributeurs --}} 
@extends('layouts.main') 
@section('body')
<h1 class="distributeurs-titre">{{ $title }}</h1>
<div class="distributeurs container">
<div class="distributeur-map">
<?php $position = get_field('position'); ?>
    <div class="map"  data-lat="<?=  $position['lat'] ?>" data-lng="<?=  $position['lng'] ?>"></div>
</div>
<div class="distributeurs-recherche">
    <input type="text" id="location" placeholder="{{ __('Search','prograin') }}">
</div>
    <div class="distributeur-liste" id="app">
        @doquery(['post_type' => 'dist-prograin','posts_per_page' => -1]) @foreach ($posts as $post)
        <div data-href="{{ $post->meta->location_url }}" data-id="{{ $post->id }}" class="distributeur-item"<?php
        if ($data = get_field('carte',$post->id)) {
            echo ' data-lat="'.$data['lat'].'"';
            echo ' data-lng="'.$data['lng'].'"'; 
        }
        echo ' data-ville="'.$post->meta->location_city.'"';
           
        ?>>
            <h2>{!! $post->title  !!}</h2>
            <div class="row gap bottom">
                <div class="col-md-4">
                    <address>
            <?= ($post->meta->location_address) ? $post->meta->location_address.'<br>' : ''; ?>
            <?= ($post->meta->location_address2 ) ? $post->meta->location_address2.'<br>' : ''; ?>
            {{ $post->meta->location_city }} 
            <?= ($post->meta->location_state) ? '('.$post->meta->location_state.')' : ''; ?>
            {{ $post->meta->location_country }}
            {{ $post->meta->location_zip }}
                </address>
                </div> 
                <div class="col-md-4">
                    <?php
                    if ($data = get_field('telephone',$post->id)) {
                echo implode('<br>',array_map(function($item){  
                    return $item["telephone"]; 
                    },
                    $data
                    )
                    );
                 } ?>
                </div>
                <div class="col-md-4">
                        <?php
                        if ($data = get_field('liste_contact',$post->id)) {
                echo implode('<br>',array_map(function($item){ 
                    return $item["nom"]; 
                    },
                    $data
                    )
                    );
                 } ?>
                </div>
            </div>
        </div>
        @endforeach @endquery
    </div>
</div>
@endsection