@extends('layouts.main')
@section('body')
    <div class="container ">
        <div class="inside">
            <div class="article-headpart wp-block-balise-section-block alignfull _sectionblock has-1-columns">
                <div style="color:#ffffff;background-image:url(<?php $picture = get_field('headimg',$id); echo $picture['url']; ?>);background-size:cover;padding-top:60px;padding-bottom:60px;padding-left:10px;padding-right:10px">
                    <div class="row">
                        <div class="col-12 col-md-8 col-lg-6">
                            <?php $term = get_queried_object(); ?>
                            <h1>{{ $title }}</h1>
                            <div class="">
                                {!! apply_filters('the_content', $term->description) !!}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="article-categories">
                <div class="row gap">
                    <div class="col-12">
                        {{ $categories = get_categories() }}
                        @if($categories && count($categories) > 1)
                            <p><?php echo pll_current_language() == 'fr' ? 'Catégories' : 'Categories' ?></p>
                            <ul>
                                <?php $blogID = get_option( 'page_for_posts' ); ?>
                                <li><a href="{{ the_permalink($blogID) }}">{{ __('All','prograin') }}</a></li>
                                @foreach ($categories as $category)
                                    <li><a href="{{ get_term_link($category->term_id) }}" @if($term->term_id == $category->term_id) class="active" @endif>{{ $category->name }}</a></li>
                                @endforeach
                            </ul>
                        @endif
                    </div>
                </div>
            </div>
            <div class="article-listing">
                @if ($posts)
                    <div class="row gap">
                        @foreach ($posts as $post)
                            <div class="col-lg-4 col-md-6 col-12 article-item">
                                <a href="{{ $post->url }}"><?php echo get_the_post_thumbnail($post->id, 'large'); ?></a>
                                <h3><a href="{{ $post->url }}">{{ $post->title }}</a></h3>
                                <div class="meta">
                                    {{ $post->date }}
                                </div>
                                {!! $post->excerpt !!}
                                <div class="button">
                                    <a class="btn" href="{{ $post->url }}">{{ __('Read the article','prograin') }}</a>
                                </div>


                            </div>
                        @endforeach
                    </div>

                @else
                    <div>
                    </div>
                @endif
            </div>
        </div>
    </div>
@endsection