@extends('layouts.main') 
@section('body') @if (get_query_var('soya',false))
    @include('soya.single') @else

<div class="container ">
    <div class="inside semence-page">
        <div class="row gap top">
            <div class="col-lg-6 col-xl-4">
                <h1>{{ $title }}</h1>
            </div>
            <div class="col-lg-6 col-xl-4 semences-sous-titre">
                <h2>{{ $excerpt }}</h2>
            </div>
        </div>
        <div class="row gap">

            <div class="col-lg-6 col-xl-4">
                <div class="row">
                    <div class="col-sm-6 col-lg-12">
                        <div class="semence-bigdata">
                            <small>    {{ __('CHU','prograin') }}</small>
                            <div class="data">{{ $meta->utm }}</div>
                        </div>
                    </div>
                    <div class="col-sm-6 col-lg-12">
                        <div class="semence-bigdata">
                            <small>    {{ __('RM','prograin') }}</small>
                            <div class="data">{{ $meta->mr }}</div>
                        </div>
                    </div>
                </div>

            </div>
            <div class="col-lg-6 col-xl-6 semence-texte">
                <div class="row gap middle">
                    <div class="col-md-6">
                        @if (@$taxonomy->semences_categories->terms) @foreach ($taxonomy->semences_categories->terms as $term)
                        <img src="{{ attachement($term->meta->image) }}" /> @endforeach @endif
                    </div>
                    <div class="col-md-6">
                        @if ($meta->image_grain)
                        <img src="{{ attachement($meta->image_grain) }}" alt="{{ __("Grain picture","prograin ") }}">                        @endif
                    </div>
                </div>

            </div>
            <div class="col-md-8 col-lg-6 col-xl-4">
                <div class="semences-tracks">
                    @if ($data = $meta->car_agro_tenue)
                    <div class="semence-track">
                        <div class="label">{{ __("Standability",'prograin') }}</div>
                        <div>
                            <div class="track"> @for ($i = 0; $data > $i; $i++) <span></span> @endfor </div>
                            <div class="value">{{ $data }}</div>
                        </div>
                    </div>
                    @endif @if ($data = $meta->car_agro_tolerance_sclerotinia)
                    <div class="semence-track">
                        <div class="label">{{ __("Tolerance to white mold","prograin") }}</div>
                        <div>
                            <div class="track"> @for ($i = 0; $data > $i; $i++) <span></span> @endfor </div>
                            <div class="value">{{ $data }}</div>
                        </div>
                    </div>
                    @endif @if ($data = $meta->car_agro_stabilite_adaptabilite)
                    <div class="semence-track">
                        <div class="label">{{ __("Stability/adaptability","prograin") }}</div>
                        <div>
                            <div class="track"> @for ($i = 0; $data > $i; $i++) <span></span> @endfor </div>
                            <div class="value">{{ $data }}</div>
                        </div>
                    </div>
                    @endif @if ($data = $meta->car_agro_vigueur_semis_direct)
                    <div class="semence-track">
                        <div class="label">{{ __("Vigour for no-till","prograin") }}</div>
                        <div>
                            <div class="track"> @for ($i = 0; $data > $i; $i++) <span></span> @endfor </div>
                            <div class="value">{{ $data }}</div>
                        </div>
                    </div>
                    @endif @if ($data = $meta->car_agro_adaptation_semis_30_po)
                    <div class="semence-track">
                        <div class="label">{{ __("Adaptability to 30″","prograin") }}</div>
                        <div>
                            <div class="track"> @for ($i = 0; $data > $i; $i++) <span></span> @endfor </div>
                            <div class="value">{{ $data }}</div>
                        </div>
                    </div>
                    @endif
                </div>
                

            </div>
            <div class="col-md-8 col-lg-9 col-xl-6 semence-texte">

                <div class="row gap">
                    <div class="col-xl-6">
                        {!! $meta->points_interets !!}
                    </div>
                    <div class="col-xl-6">
                        {!! $meta->points_regie !!}
                    </div>
                </div>
            </div>
            <div class="col-md-4 col-lg-3 col-xl-2 semence-texte">
                @if ($meta->image)
                <div class="semence-plant-image semences-images-data">
                        <img src="{{ attachement($meta->image) }}" alt="{{ __(" Image du plant ","prograin ") }}">
                        {!! ($meta->car_agro_type_de_plant) ? $meta->car_agro_type_de_plant."<br>" : '' !!}
                        {{ $meta->car_agro_longeur_plant }} 
                        
                </div> 
                @endif
            </div>
            <div class="col-lg-4">
                    <?php
                    $ogm_cats = array_map(function ($i) {return intval($i->term_id);}, get_terms('semences_categories', array(
                            'hide_empty' => false,
                            'meta_query' => array(
                                [
                                    'key' => 'ogm',
                                    'value' => 1,
                                    'compare' => '=',
                                ],
                            ),
                        )));
                        $noogm = true;
                    
                        if (@$taxonomy->semences_categories->terms ) {
                            foreach($taxonomy->semences_categories->terms as $term) { 
                                if (in_array(intval($term->id), $ogm_cats)) {
                                    $noogm = false;
                                }
                    }
                        }   
                                    $q = new WP_Query(['s'=> '[semenceslist '.(($noogm) ? 'noogm': 'ogm').']','sentence' => true]);
                                    if($q->have_posts()) {
                                        $q->the_post();
                                        ?>
                                        <a class="semence-retour" href="<?php echo get_permalink(); ?>"><i class="icon-backarrow"></i> {{ __('Back to the list','prograin') }}</a>
                                        <?php
                                        wp_reset_postdata();
                                    }
                                    
                                    ?>
                    
            </div>
            <div class="col-lg-8">
                    <a href="{{ ($data = get_field('buy_seed_'.substr(get_locale(),0,2),'option')) ? $data : pageByTemplate("distributeurs") }}" class="btn">{{ __('Buy your seeds','prograin') }}</a>
                    @if(!get_field('hide_resultats','option'))
                    <a href="#resultats" class="btn results-btn">{{ __('See our plot results','prograin') }}</a>
                    @endif
            </div>

        </div>









    </div>
    <div class="inside semence-page-bas">



        <div class="row gap">
            <div class="col-lg-6 col-xl-4" id="resultats">
                <table class="semence-tableau">
                    <caption>
                        {{ __("Characteristics of the variety","prograin") }}
                    </caption>

                    <tbody>
                        <tr>
                            <th>{{ __("Days to maturity",'prograin') }}<sup>*</sup></th>
                            <td>{{ ($data = $meta->car_agro_maturite) ? $data : __('N/A','prograin') }}</td>
                        </tr>
                        <tr>
                            <th>{{ __("Hilum colour",'prograin') }}</th>
                            <td>{{ ($data = $meta->car_couleur_chile) ? $data : __('N/A','prograin') }}</td>
                        </tr>
                        <tr>
                            <th>{{ __("Pubescence colour",'prograin') }}</th>
                            <td>{{ ($data = $meta->car_couleur_pubescence) ? $data : __('N/A','prograin') }}</td>
                        </tr>
                        <tr>
                            <th>{{ __("Flower colour",'prograin') }}</th>
                            <td>{{ ($data = $meta->car_couleur_fleurs) ? $data : __('N/A','prograin') }}</td>
                        </tr>
                        <tr>
                            <th>{{ __("Number of seeds/kg",'prograin') }}</th>
                            <td>{{ ($data = $meta->car_nombre_grains_kg) ? $data : __('N/A','prograin') }}</td>
                        </tr>
                        <tr>
                            <th>{{ __("Protein %",'prograin') }}</th>
                            <td>{{ ($data = $meta->car_teneur_proteine) ? $data : __('N/A','prograin') }}</td>
                        </tr>
                    </tbody>
                </table>
                <small><sup>*</sup> {{ __("Days to maturity counted in its adaptation zone",'prograin') }}</small>
            </div>
            <div class="col-lg-6 col-xl-4">
                <table class="semence-tableau">
                    <caption>
                        {{ __("Field performance","prograin") }}
                    </caption>

                    <tbody>
                        <tr>
                            <th>{{ __("Plant type",'prograin') }}</th>
                            <td>{{ ($data = $meta->car_agro_type_de_plant) ? $data : __('N/A','prograin') }}</td>
                        </tr>
                        <tr>
                            <th>{{ __("Plant height",'prograin') }}</th>
                            <td>{{ ($data = $meta->car_agro_longeur_plant) ? $data : __('N/A','prograin') }}</td>
                        </tr>
                        <tr>
                            <th>{!! __("Resistance gene to <i>Phytophthora</i>",'prograin') !!}</th>
                            <td>{{ ($data = $meta->car_gene_resistance_phytophora) ? $data : __('N/A','prograin') }}</td>
                        </tr>
                        <tr>
                            <th>{{ __("Resistance gene to the Soybean Cyst Nematode (SCN)",'prograin') }}</th>
                            <td>{{ ($data = $meta->car_gene_resistance_nematode_kyste_soya) ? $data : __('N/A','prograin') }}</td>
                        </tr>
                        <tr>
                            <th>{{ __('Metribuzin tolerance','prograin') }}</th> 
                            <td>{{ ($data = get_field('carmataribuzin')) ? $data : __('N/A','prograin') }}</td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="col-xl-4">
                <table class="semence-tableau semence-tableau-taux">


                    <caption>
                        {{ __("Seeding rate and populations according to row spacing","prograin") }}
                        <small>{{ __("(number of seeds per metre)","prograin") }}</small>
                    </caption>

                    <tbody>
                        <tr>
                            <th rowspan="3">{{ __("7 in / 18 cm",'prograin') }}</th>
                            <td>{{ ($data = $meta->taux_semis_7_po) ? $data : __('N/A','prograin') }} {{ pll_current_language() == 'fr' ? 'sacs/ha' : 'bags/ha'
                                }}
                            </td>
                        </tr>
                        <tr>
                            <td>{{ ($data = $meta->nb_grains_ha_7_po) ? $data : __('N/A','prograin') }} {{ __('seeds/ha','prograin')
                                }}
                            </td>
                        </tr>
                        <tr>
                            <td>{{ ($data = $meta->nb_grains_m_7_po) ? $data : __('N/A','prograin') }} {{ __('seeds/m','prograin')
                                }}
                            </td>
                        </tr>
                        <tr>
                            <th rowspan="3">{{ (get_field('westcan_metric','option')) ? __("15 in / 38 cm",'prograin') : __("14 in / 35 cm",'prograin') }}</th>
                            <td>{{ ($data = $meta->taux_semis_14_po) ? $data : __('N/A','prograin') }} {{ pll_current_language() == 'fr' ? 'sacs/ha' : 'bags/ha'
                                }}
                            </td>
                        </tr>
                        <tr>
                            <td>{{ ($data = $meta->nb_grains_ha_14_po) ? $data : __('N/A','prograin') }} {{ __('seeds/ha','prograin')
                                }}
                            </td>
                        </tr>
                        <tr>
                            <td>{{ ($data = $meta->nb_grains_m_14_po) ? $data : __('N/A','prograin') }} {{ __('seeds/m','prograin')
                                }}
                            </td>
                        </tr>

                        <tr>
                            <th rowspan="3">{{ (get_field('westcan_metric','option')) ? __("22 in / 56 cm",'prograin') : __("30 in / 75 cm",'prograin') }}</th>
                            <td>{{ ($data = $meta->taux_semis_30_po) ? $data : __('N/A','prograin') }} {{ pll_current_language() == 'fr' ? 'sacs/ha' : 'bags/ha'
                                }}
                            </td>
                        </tr>
                        <tr>
                            <td>{{ ($data = $meta->nb_grains_ha_30_po) ? $data : __('N/A','prograin') }} {{ __('seeds/ha','prograin')
                                }}
                            </td>
                        </tr>
                        <tr>
                            <td>{{ ($data = $meta->nb_grains_m_30_po) ? $data : __('N/A','prograin') }} {{ __('seeds/m','prograin')
                                }}
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    @if(!get_field('hide_resultats','option'))
    <?php
    $parcelles = Prograin\Parcelle::whereHas('variete', function ($query) use ($title) { 
        $query->where('variete_nom', $title);
        $query->where('variete_nom', $title);
    })->get()->filter(function($el){
if (substr($el->resultat->date_semis,0,10) < date('Y-m-d',time()-31536000)) return false;
        return true;
    });


    $page = pageByTemplate("resultats");
?>
        
        <div class="inside semences-single-resultats ">
            <h2 class="semences-parcelles">{{ __('Plot results','prograin') }}</h2>
            @if ($parcelles && count($parcelles) > 0)
            <table>
                <thead>
                    <th>{{ __('Producer','prograin') }}</th>
                    <th>{{ __('City','prograin') }}</th>
                    <th>{{ __('Planting date','prograin') }}</th>
                    <th>{{ __('Spacing','prograin') }}</th>
                    <th>{{ __('Humidity','prograin') }}</th>
                    <th>{{ __('Row length','prograin') }}</th>
                    <th>{{ __('Row width','prograin') }}</th>
                    <th>{{ __('Row count','prograin') }}</th>
                    <th>{{ __('Weight (lb)','prograin') }}</th>
                    <th>{{ __('MT/acre','prograin') }}</th>
                    <th>{{ __('bsh/acre','prograin') }}</th>
                    <th>{{ __('Results','prograin') }}</th>
                </thead>
                <tbody>
                    @foreach ($parcelles as $parcelle)
                    <tr>
                        <td>{{ $parcelle->resultat->producteur->producteur_nom }}</td>
                        <td>{{ $parcelle->resultat->producteur->ville }}</td>
                        <td>{{ substr($parcelle->resultat->date_semis,0,10) }}</td>
                        <td>{!! (@$parcelle->resultat->espacement->espacement) ? $parcelle->resultat->espacement->espacement.
                            "&#8221;": "-" !!}</td>
                        <td>{{ $parcelle->humidite }}%</td>
                        <td>{{ $parcelle->longueur_rang}}&#8217;</td>
                        <td>{{ $parcelle->largeur_rang}}&#8221;</td>
                        <td>{{ $parcelle->nombre_rang}}</td>
                        <td>{{ $parcelle->poids}}</td>
                        <td>{{ number_format ( $parcelle->rendement, 2) }}</td>
                        <td>{{ number_format ( $parcelle->rendement* 1000 / 27.215, 2) }}</td>
                        <td><a href="{{ $page }}#id={{ $parcelle->resultat->resultat_id  }}" class="arrow"></a></td>

                    </tr>
                    @endforeach
                </tbody>
            </table>
            @else
            <div class="noresults">{{ __('No plot result has been found','prograin') }}</div>
            @endif
        </div>
        @endif

    <?php  $terms = get_the_terms( get_the_ID(), 'semences_categories' );
        if(!empty($terms)){ foreach ($terms as $term){
                if(in_array($term->term_id,[8,9,86,132])){ ?>
           <div class="inside semences-single-resultats " style="font-size:12px;">
               <?php the_field("legal_text",$term->taxonomy . '_' . $term->term_id)?>
           </div>
    <?php }}} ?>

</div>
@endif
@endsection