(() => {     
    const {
        registerBlockType
    } = wp.blocks;

    function generateDeprecated (blocklist) {
        let block = blocklist.pop()
        if (!block.deprecated) block.deprecated = [];
        block.deprecated = block.deprecated.concat(blocklist)
        return block; 
         
    } 
      
    registerBlockType(
        'prograin/section-block', 
        generateDeprecated([
            require('./versions/block-001.jsx')
        ])
    );
    registerBlockType(
        'prograin/section-block-col', 
        generateDeprecated([
            require('./versions/col-001.jsx'),
            require('./versions/col-002.jsx'),
            require('./versions/col-003.jsx')
        ])
    );
    registerBlockType(
        'prograin/section-block-col-main', 
        generateDeprecated([
            require('./versions/main-001.jsx'),
            require('./versions/main-002.jsx'),
            require('./versions/main-003.jsx')
        ])
    );
})();     
