(function () {

    document.querySelectorAll(".prograin-home li").forEach(node => {
        let slide = node.querySelectorAll(".prograin-home-slide")
        node.addEventListener("mouseenter", function () {
            document.querySelectorAll(".prograin-home-slide.active").forEach(element => {
                element.classList.remove("active")
            });
            slide.forEach(element => {
                element.classList.add("active")
                if (element.classList.contains("light")) {
                    document.body.classList.add("light")
                } else {
                    document.body.classList.remove("light")
                }
            });
        });
    });
    
    let home = document.querySelector(".prograin-home .home");
    if (home) home.addEventListener("mouseleave", function () {
        document.querySelectorAll(".prograin-home-slide.active").forEach(element => {
            element.classList.remove("active")
        });
        document.querySelector(".prograin-home-slide").classList.add("active")
    });
    


    if (document.querySelector(".prograin-home-slide")) {

        document.querySelectorAll(".prograin-home").forEach(home => {
            home.querySelectorAll(".prograin-home-slide").forEach(node => {
                home.appendChild(node);
            })
            document.querySelector(".prograin-home-slide").classList.add('active');
        })

    }
    var UID = {
        _current: 0,
        getNew: function () {
            this._current++;
            return this._current;
        }
    };
    HTMLElement.prototype.pseudoStyle = function (element, props) {
        var _this = this;
        var _sheetId = "pseudoStyles";
        var _head = document.head || document.getElementsByTagName('head')[0];
        var _sheet
        var className

        if (!_this._pseudoStyleStyle) {
            _this._pseudoStyleStyle = document.createElement('style');
        }
        _sheet = _this._pseudoStyleStyle
        if (!_this._pseudoStyleClass) {
            className = "pseudoStyle" + UID.getNew();
            _this.className += " " + className;
            _this._pseudoStyleClass = className
            _head.appendChild(_sheet);
        } else {
            className = _this._pseudoStyleClass
        }
        _this.pseudoStyleClass = className
        _sheet.innerHTML = " ." + className + ":" + element + "{";
        for (var prop in props) {
            _sheet.innerHTML += prop + ":" + props[prop] + ";";
        }
        _sheet.innerHTML += "}";

        return this;
    };

    if (document.querySelector('.prograin-home ul.home')) {
        let contact = document.createElement("li")
        
        contact.innerHTML = " " + document.querySelector("footer .telephone").innerHTML
        
        let espace = document.createElement("li")
        if (document.querySelector("footer .espaceclient")) {
            espace.classList.add("small", )
            espace.classList.add("client")
            espace.classList.add("footer")
            contact.classList.add("small",)
            contact.classList.add("footer")
            
            espace.innerHTML = " " + document.querySelector("footer .espaceclient").innerHTML
            
        }
        document.querySelector('.prograin-home ul.home').appendChild(contact);
        if (document.querySelector("footer .espaceclient")) {
        document.querySelector('.prograin-home ul.home').appendChild(espace);
        }
        document.querySelector('footer').classList.add('on-home')
    }




    document.querySelectorAll('.prograin-home li').forEach((item) => {
        item.addEventListener('mousemove', (e) => {
            var x = e.pageX - item.getBoundingClientRect().left;
            var y = e.pageY - item.getBoundingClientRect().top;
            item.pseudoStyle("before", {
                "left": x + "px !important",
                "top": y + "px !important",
            });
        })
    });





    (function () {
        if (!window.document.querySelectorAll) {
            document.querySelectorAll = document.body.querySelectorAll = Object.querySelectorAll = function querySelectorAllPolyfill(r, c, i, j, a) {
                var d = document,
                    s = d.createStyleSheet();
                a = d.all;
                c = [];
                r = r.replace(/\[for\b/gi, '[htmlFor').split(',');
                for (i = r.length; i--;) {
                    s.addRule(r[i], 'k:v');
                    for (j = a.length; j--;) {
                        a[j].currentStyle.k && c.push(a[j]);
                    }
                    s.removeRule(0);
                }
                return c;
            };
        }
    })();
    if (!Array.prototype.forEach) {
        Array.prototype.forEach = function (callback) {
            var T, k;
            if (this == null) {
                throw new TypeError(' this vaut null ou n est pas défini');
            }
            var O = Object(this);
            var len = O.length >>> 0;
            if (typeof callback !== "function") {
                throw new TypeError(callback + ' n est pas une fonction');
            }
            if (arguments.length > 1) {
                T = arguments[1];
            }
            k = 0;
            while (k < len) {
                var kValue;
                if (k in O) {
                    kValue = O[k];
                    callback.call(T, kValue, k, O);
                }
                k++;
            }
        };
    }
    if (!NodeList.prototype.forEach) {
        NodeList.prototype.forEach = Array.prototype.forEach
    }

    function toArray(input) {
        var returnValue = []
        for (var i in input) {
            if (parseInt(i) === i || "" + parseInt(i) === i) {
                returnValue.push(input[i])
            }
        }
        return returnValue;
    }
    toArray(document.querySelectorAll(".no-cssgrid .box")).forEach(function (box) {
        var wrap = document.createElement("div")
        box.childNodes.forEach(function (cell) {
            wrap.appendChild(cell)
        })
        box.appendChild(wrap)
    })
    toArray(document.querySelectorAll(".no-cssgrid .grid")).forEach(function (grid) {
        var totalHeight = 0
        grid.childNodes.forEach(function (cell) {
            if (cell.getBoundingClientRect) {
                totalHeight = (cell.getBoundingClientRect().bottom > totalHeight) ? cell.getBoundingClientRect().bottom : totalHeight;
            }
        })
        grid.childNodes.forEach(function (cell) {
            if (cell.getBoundingClientRect) {
                var height = cell.getBoundingClientRect().height || cell.scrollHeight || cell.clientHeight;
                cell.style.height = height * 100 / totalHeight + "%"
            }
        })

    })

})();


if (!document.documentElement.classList.contains("cssgrid")) {
    let totalBlock = document.querySelectorAll("ul.home li").length;
    let smallBlock = document.querySelectorAll("ul.home li.small").length;
    let rows = Math.ceil((totalBlock-smallBlock)/2);

    var style = document.createElement("style");
    document.head.appendChild(style);
    
    style.innerHTML = `
@media (min-width: 64pc) {
    ul.home li {
        height: ${100/rows}% !important;
    }  
    ul.home li.small {
        height: ${50/rows}% !important;
    }
}
    `
}