const allElements = Object.assign({}, wp.i18n, wp.blocks, wp.editor, wp.element, wp.components)
const {
    __,
    InnerBlocks,
    SelectControl,
    Fragment
} = allElements;





module.exports = { 
    title: __("Prograin Home", "prograin"),
    icon: "layout",
    category: "layout",
    supports: {
      align: ["full"],  
      customClassName: false,
      inserter: true
    }, 
    attributes: {
      type: {
        type: "string",
        source: "attribute",
        selector: ".prograin-home>ul", 
        attribute: "class",
        default: "home"
      }
    },

    edit({ className, attributes, setAttributes }) {
      const setType = type => {
        setAttributes({ type });
      };
      return (
        <Fragment>
          <div class="prograin-title-box">
            <SelectControl
              value={attributes.type}
              options={[
                { label: "Accueil", value: "home" },
                { label: "Sous-section", value: "subsection" }
              ]}
              onChange={setType}
            />
          </div>
          <div className={`prograin-home ` + attributes.type}>
            <ul>
              <InnerBlocks
                template={[
                  [
                    "prograin/section-block-col-main",
                    "prograin/section-block-col"
                  ]
                ]}
                allowedBlocks={[
                  "prograin/section-block-col-main",
                  "prograin/section-block-col"
                ]}
              />
            </ul>
          </div>
        </Fragment>
      );
    },
    save({ attributes }) {
      let style = {};
      return (
        <div className={`prograin-home`}>
          <ul className={attributes.type}>
            <InnerBlocks.Content />
          </ul> 
        </div>
      );
    }
  }