const allElements = Object.assign({}, wp.i18n, wp.blocks, wp.editor, wp.element, wp.components)
const {
    __,
    InnerBlocks,
    SelectControl,
    PanelBody,
    Button,
    TextControl,
    InspectorControls,
    PanelColorSettings,
    MediaUpload,
    Fragment
} = allElements;
const ALLOWED_MEDIA_TYPES = ["image"];


  const generateStyle = function(attributes) {
    let style = {};
    if (attributes.backgroundColor) {
      style.backgroundColor = attributes.backgroundColor;
    }
    if (attributes.textColor) {
      style.color = attributes.textColor;
    }
    if (attributes.backgroundImage) {
      style.backgroundImage = `url(${
        attributes.backgroundImage.sizes.full.url
      })`;
    }
    if (attributes.backgroundMode === "fill") {
      style.backgroundSize = "cover";
      if (attributes.backgroundLeft && attributes.backgroundTop) {
        style.backgroundPosition = `${attributes.backgroundLeft}% ${
          attributes.backgroundTop
        }%`;
      }
    }

    return style;
  };

  let BackgroundPreview = function(props) {
    let left = props.left || 50;
    let top = props.top || 50; 

    return (
      <div
        style={{
          marginBottom: "10px",
          paddingBottom: "100%",
          position: "relative",
          overflow: "hidden"
        }} 
        onClick={e => {
          if (props.onChange && props.mode === "fill") {
            var rect = e.currentTarget.getBoundingClientRect();
            var x = e.clientX - rect.left; //x position within the element.
            var y = e.clientY - rect.top; //y position within the element.
            props.onChange((x * 100) / rect.width, (y * 100) / rect.height);
          } 
        }}
      >
        <div
          style={{
            position: "absolute",
            top: -top / 5 + "%",
            left: -left / 5 + "%",
            width: "120%",
            height: "120%",
            backgroundImage: `url(${props.image})`,
            backgroundSize: props.mode === "fill" ? "cover" : "",
            cursor: props.mode === "fill" ? "pointer" : "",
            backgroundPosition: props.mode === "fill" ? `${left}% ${top}%` : ""
          }}
        />
      </div>
    );
  };

  const parseStyle = function(style) {};

module.exports = {
    title: __("Subsection", "prograin"),

    icon: "layout",
    category: "layout",
    parent: ["prograin/section-block"],
    attributes: {
        textColor: {
            type: "color"
        },
        backgroundColor: {
            type: "color"
        },
        backgroundImage: {
            type: "image"
        },
        backgroundMode: {
            type: "string",
            default: "fill"
        },
        backgroundLeft: {
            type: "number"
        },

        backgroundTop: {
            type: "number"
        },
        paddingRight: {
            type: "string",
            default: "50%"
        },
        url: {
            type: "string",
            selector: "a",
            source: "attribute",
            attribute: "href"
        },
        label: {
            type: "string",
            selector: "a",
            source: "text"
        }
    },
    deprecated: [
        {
            attributes: {
                textColor: {
                    type: "color"
                },
                backgroundColor: {
                    type: "color"
                },
                backgroundImage: {
                    type: "image"
                },
                url: {
                    type: "string",
                    selector: "a",
                    source: "attribute",
                    attribute: "href"
                },
                label: {
                    type: "string",
                    selector: "a",
                    source: "text"
                }
            },

            save({ attributes }) {
                const style = generateStyle(attributes);
                return (
                    <Fragment>
                        <li>
                            <a href={attributes.url}>{attributes.label}</a>
                            <div className={`prograin-home-slide`} style={style}>
                                <div
                                    className="inside"
                                    style={{ paddingRight: attributes.paddingRight }}
                                >
                                    <InnerBlocks.Content />
                                </div>
                            </div>
                        </li>
                    </Fragment>
                );
            }
        },
        {
            attributes: {
                textColor: {
                    type: "color"
                },
                backgroundColor: {
                    type: "color"
                },
                backgroundImage: {
                    type: "image"
                },
                backgroundMode: {
                    type: "string",
                    default: "fill"
                },
                backgroundLeft: {
                    type: "number"
                },

                backgroundTop: {
                    type: "number"
                },
                url: {
                    type: "string",
                    selector: "a",
                    source: "attribute",
                    attribute: "href"
                },
                label: {
                    type: "string",
                    selector: "a",
                    source: "text"
                }
            },

            save({ attributes }) {
                const style = generateStyle(attributes);
                return (
                    <Fragment>
                        <li>
                            <a href={attributes.url}>{attributes.label}</a>
                            <div className={`prograin-home-slide`} style={style}>
                                <div
                                    className="inside"
                                    style={{ paddingRight: attributes.paddingRight }}
                                >
                                    <InnerBlocks.Content />
                                </div>
                            </div>
                        </li>
                    </Fragment>
                );
            }
        }
    ],
    save: function ({ attributes }) {
        const style = generateStyle(attributes);
        return (
            <Fragment>
                <li>
                    <div className={`prograin-home-slide`} style={style}>
                        <div className="inside">
                            <InnerBlocks.Content />
                        </div>
                    </div>
                </li>
            </Fragment>
        );
    },
    edit({ className, attributes, setAttributes }) {
        const setLabel = label => {
            setAttributes({ label });
        };
        const setUrl = url => {
            setAttributes({ url });
        };
        const setTextColor = textColor => {
            setAttributes({ textColor });
        };
        const setBackgroundColor = backgroundColor => {
            setAttributes({ backgroundColor });
        };
        const onSelectImage = backgroundImage => {
            if (!backgroundImage) {
                setAttributes({
                    backgroundImage: {
                        url: undefined,
                        alt: undefined,
                        id: undefined,
                        caption: undefined
                    }
                });
            } else {
                setAttributes({ backgroundImage });
            }
        };
        const style = generateStyle(attributes);
        return (
            <Fragment>
                <InspectorControls>
                    <PanelBody title="Link">
                        <TextControl
                            placeholder="Label"
                            value={attributes.label}
                            onChange={setLabel}
                        />
                        <TextControl
                            placeholder="http://"
                            value={attributes.url}
                            onChange={setUrl}
                        />
                    </PanelBody>
                    <PanelBody title="Image de fond">
                        <SelectControl
                            label="Type"
                            value={attributes.backgroundMode}
                            onChange={value => {
                                setAttributes({ backgroundMode: value });
                            }}
                            options={[
                                { label: "Mosaique", value: "pattern" },
                                { label: "Fill", value: "fill" }
                            ]}
                        />
                        {attributes.backgroundImage && attributes.backgroundImage.id && (
                            <BackgroundPreview
                                mode={attributes.backgroundMode}
                                left={attributes.backgroundLeft}
                                top={attributes.backgroundTop}
                                image={attributes.backgroundImage.sizes.full.url}
                                onChange={(left, top) => {
                                    setAttributes({ backgroundLeft: left, backgroundTop: top });
                                }}
                            />
                        )}
                        <MediaUpload
                            onSelect={onSelectImage}
                            allowedTypes={ALLOWED_MEDIA_TYPES}
                            value={
                                attributes.backgroundImage && attributes.backgroundImage.id
                            }
                            render={({ open }) => (
                                <Button isDefault onClick={open}>
                                    {attributes.backgroundImage
                                        ? "Change image"
                                        : "Add a background"}
                                </Button>
                            )}
                        />
                    </PanelBody>
                    <PanelBody title="Width">
                        <TextControl
                            placeholder="50%, 200px, ...."
                            value={attributes.paddingRight}
                            onChange={paddingRight => {
                                setAttributes({ paddingRight });
                            }}
                        />
                    </PanelBody>
                    <PanelColorSettings
                        title={__("Color Settings")}
                        initialOpen={true}
                        colorSettings={[
                            {
                                value: attributes.backgroundColor,
                                onChange: setBackgroundColor,
                                label: __("Background Color")
                            },
                            {
                                value: attributes.textColor,
                                onChange: setTextColor,
                                label: __("Text Color")
                            }
                        ]}
                    />
                </InspectorControls>

                <li>
                    <div className={`prograin-home-slide`} style={style}>
                        <div className="inside">
                            <InnerBlocks templateLock={false} />
                        </div>
                    </div>
                </li>
            </Fragment>
        );
    },
    save({ attributes }) {
        const style = generateStyle(attributes);
        return (
            <Fragment>
                <li>
                    <a href={attributes.url}>{attributes.label}</a>
                    <div className={`prograin-home-slide`} style={style}>
                        <div
                            className="inside"
                            style={{ paddingRight: attributes.paddingRight }}
                        >
                            <InnerBlocks.Content />
                        </div>
                    </div>
                </li>
            </Fragment>
        );
    }
}