const allElements = Object.assign({}, wp.i18n, wp.blocks, wp.editor, wp.element, wp.components)
const {
    __,
    InnerBlocks,
    SelectControl,
    PanelBody,
    Button,
    TextControl,
    InspectorControls,
    PanelColorSettings, 
    MediaUpload,
    Fragment
} = allElements;
const ALLOWED_MEDIA_TYPES = ["image"];

const generateStyle = function(attributes) {
  let style = {};
  if (attributes.backgroundColor) {
    style.backgroundColor = attributes.backgroundColor;
  }
  if (attributes.textColor) {
    style.color = attributes.textColor;
  }
  if (attributes.backgroundImage) {
    style.backgroundImage = `url(${
      attributes.backgroundImage.sizes.full.url
    })`;
  }
  if (attributes.backgroundMode === "fill") {
    style.backgroundSize = "cover";
    if (attributes.backgroundLeft && attributes.backgroundTop) {
      style.backgroundPosition = `${attributes.backgroundLeft}% ${
        attributes.backgroundTop
      }%`;
    }
  }

  return style;
};


const generateStyle2 = function(attributes) {
  let style = {};
  if (attributes.backgroundImageVertical) {
    style.backgroundImage = `url(${
      attributes.backgroundImageVertical.sizes.full.url
    })`;
  }
  if (attributes.backgroundMode === "fill") {
    style.backgroundSize = "cover";
    if (attributes.backgroundLeftVertical && attributes.backgroundTopVertical) {
      style.backgroundPosition = `${attributes.backgroundLeftVertical}% ${
        attributes.backgroundTopVertical
      }%`;
    }
  }

  return style;
};
let BackgroundPreview = function(props) {
  let left = props.left || 50;
  let top = props.top || 50;

  return (
    <div
      style={{
        marginBottom: "10px",
        paddingBottom: "100%",
        position: "relative",
        overflow: "hidden"
      }} 
      onClick={e => {
        if (props.onChange && props.mode === "fill") {
          var rect = e.currentTarget.getBoundingClientRect();
          var x = e.clientX - rect.left; //x position within the element.
          var y = e.clientY - rect.top; //y position within the element.
          props.onChange((x * 100) / rect.width, (y * 100) / rect.height);
        } 
      }}
    >
      <div
        style={{
          position: "absolute",
          top: -top / 5 + "%",
          left: -left / 5 + "%",
          width: "120%",
          height: "120%",
          backgroundImage: `url(${props.image})`,
          backgroundSize: props.mode === "fill" ? "cover" : "",
          cursor: props.mode === "fill" ? "pointer" : "",
          backgroundPosition: props.mode === "fill" ? `${left}% ${top}%` : ""
        }}
      />
    </div>
  );
};

const parseStyle = function(style) {};

module.exports = {
    title: __("Main section", "prograin"),
    icon: "layout",
    category: "layout",
    parent: ["prograin/section-block"],
    deprecated: [
      {
        attributes: {
          textColor: {
            type: "color"
          },
          backgroundColor: {
            type: "color"
          },
          backgroundImage: {
            type: "image"
          }
        },
        save({ attributes }) {
          const style = generateStyle(attributes);
          return (
            <Fragment>
              <li class="PageTitle">
                <h1>%POST_TITLE%</h1>
                <div className={`prograin-home-slide main-slide`} style={style}>
                  <div className="inside" >
                    <InnerBlocks.Content />
                  </div>
                </div>
              </li>
            </Fragment>
          );
        }
      },
      {
        attributes: {
          textColor: {
            type: "color"
          },
          backgroundColor: {
            type: "color"
          },
          backgroundImage: {
            type: "image"
          },

          backgroundMode: {
            type: "string",
            default: "fill"
          },
          backgroundLeft: {
            type: "number"
          },

          backgroundTop: {
            type: "number"
          }
        },
        save({ attributes }) {
          const style = generateStyle(attributes);
          return (
            <Fragment>
              <li class="PageTitle">
                <h1>%POST_TITLE%</h1>
                <div className={`prograin-home-slide main-slide`} style={style}>
                  <div className="inside"
                  style={{ paddingRight: attributes.paddingRight }} >
                    <InnerBlocks.Content />
                  </div>
                </div>
              </li>
            </Fragment>
          );
        }
      },
      
    ],
    attributes: {
      textColor: {
        type: "color"
      },
      backgroundColor: {
        type: "color"
      },
      backgroundImage: {
        type: "image"
      },
      backgroundImageVertical: {
        type: "image"
      },
      backgroundMode: {
        type: "string",
        default: "fill"
      },
      backgroundLeft: {
        type: "number"
      },

      backgroundTop: {
        type: "number"
      },



      backgroundImageVertical: {
        type: "image"
      },
      backgroundLeftVertical: {
        type: "number"
    },

    backgroundTopVertical: {
        type: "number"
    },
    vimeo: {
      type: "string",
  },


      paddingRight: {
        type: "string",
        default: "50%"
      }
    },
    supports: {
      reusable: false,
      multiple: false,
    },
    edit({ className, attributes, setAttributes }) {
      const setLabel = label => {
        setAttributes({ label });
      };
      const setUrl = url => {
        setAttributes({ url });
      };
      const setVimeo = vimeo => {
        setAttributes({ vimeo });
      };
      const setTextColor = textColor => {
        setAttributes({ textColor });
      };
      const setBackgroundColor = backgroundColor => {
        setAttributes({ backgroundColor });
      };
      const onSelectImage = backgroundImage => {
        if (!backgroundImage) {
          setAttributes({
            backgroundImage: {
              url: undefined,
              alt: undefined,
              id: undefined,
              caption: undefined
            }
          });
        } else {
          setAttributes({ backgroundImage });
        }
      };
      const onSelectImageVertical = backgroundImageVertical => {
        if (!backgroundImageVertical) {
          setAttributes({
            backgroundImageVertical: {
              url: undefined,
              alt: undefined,
              id: undefined,
              caption: undefined
            }
          });
        } else {
          setAttributes({ backgroundImageVertical });
        }
      };
      const style = generateStyle(attributes);
      return (
        <Fragment>
          <InspectorControls>
            <PanelBody title="Image de fond">
              <SelectControl
                label="Type"
                          value={attributes.backgroundMode}
                onChange={value => {
                  setAttributes({ backgroundMode: value });
                }}
                options={[
                  { label: "Mosaique", value: "pattern" },
                  { label: "Fill", value: "fill" }
                ]}
              />
              {attributes.backgroundImage &&
                <Button isDefault onClick={() => { setAttributes({ backgroundImage: null }) }}>
                    Remove Image
                    </Button>}
              <p>
              {attributes.backgroundImage && attributes.backgroundImage.id && (
                <BackgroundPreview
                  mode={attributes.backgroundMode}
                  left={attributes.backgroundLeft}
                  top={attributes.backgroundTop}
                  image={attributes.backgroundImage.sizes.full.url}
                  onChange={(left, top) => {
                    setAttributes({
                      backgroundLeft: left,
                      backgroundTop: top
                    });
                  }}
                />
              )}
               
              <MediaUpload
                onSelect={onSelectImage}
                allowedTypes={ALLOWED_MEDIA_TYPES}
                value={
                  attributes.backgroundImage && attributes.backgroundImage.id
                }
                render={({ open }) => (
                  <Button isDefault onClick={open}>
                    {attributes.backgroundImage
                      ? "Change image"
                      : "Add a horizontal background"}
                  </Button>
                )}
              />{attributes.backgroundImageVertical &&
                <Button isDefault onClick={() => { setAttributes({ backgroundImageVertical: null }) }}>
                    Remove Image
                    </Button>}
              </p>
<p>

{attributes.backgroundImageVertical && attributes.backgroundImageVertical.id && (
    <BackgroundPreview
      mode={attributes.backgroundMode}
      left={attributes.backgroundLeftVertical}
      top={attributes.backgroundTopVertical}
      image={attributes.backgroundImageVertical.sizes.full.url}
      onChange={(left, top) => {
        setAttributes({
          backgroundLeftVertical: left,
          backgroundTopVertical: top
        });
      }}
    />
  )}
  <MediaUpload
    onSelect={onSelectImageVertical}
    allowedTypes={ALLOWED_MEDIA_TYPES}
    value={
      attributes.backgroundImageVertical && attributes.backgroundImageVertical.id
    }
    render={({ open }) => (
      <Button isDefault onClick={open}>
        {attributes.backgroundImageVertical
          ? "Change vertical image"
          : "Add a vertical background"}
      </Button>
    )}
  />
</p>

<TextControl
                            placeholder="Vimeo ID"
                            value={attributes.vimeo}
                            onChange={setVimeo}
                        />
            </PanelBody>
            <PanelBody title="Width">
              <TextControl
                          placeholder="50%, 200px, ...."
                value={attributes.paddingRight}
                onChange={paddingRight => {
                  setAttributes({ paddingRight });
                }}
              />
            </PanelBody>
            <PanelColorSettings
              title={__("Color Settings")}
              initialOpen={true}
              colorSettings={[
                {
                  value: attributes.backgroundColor,
                  onChange: setBackgroundColor,
                  label: __("Background Color")
                },
                {
                  value: attributes.textColor,
                  onChange: setTextColor,
                  label: __("Text Color")
                }
              ]}
            />
          </InspectorControls>

          <li>
            <div className={`prograin-home-slide main-slide`} style={style}>
              <div className="inside">
                <InnerBlocks templateLock={false} />
              </div>
            </div>
          </li>
        </Fragment>
      );
    },
    save({ attributes }) {
      const style = generateStyle(attributes);
      const style2 = generateStyle2(attributes);
      return (
        <Fragment>
          <li class="PageTitle">
            <h1>%POST_TITLE%</h1>
            <div className={`prograin-home-slide main-slide`} style={style}>
            <div className="verticalbg" style={style2}></div>
            {attributes.vimeo && 
            <iframe className="videobg" src={ "https://player.vimeo.com/video/"+attributes.vimeo+"?background=1&autoplay=1&byline=0&title=0&muted=1" }
           frameborder="0" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>
          }
              <div
                className="inside"
                style={{ paddingRight: attributes.paddingRight }}
              >
                <InnerBlocks.Content />
              </div>
            </div>
          </li>
        </Fragment>
      );
    }
  }