const allElements = Object.assign({}, wp.i18n, wp.blocks, wp.editor, wp.element, wp.components)
const {
    Component,
    __
} = allElements;

class Choix extends Component {
    constructor(props) {
        super(props)
        this.state = {
            categories: []
        }
    }
    componentDidMount() { 
        wp.apiFetch({
            path: '/wp/v2/carrieres-cat'
            })
            .then((response) => {
               this.setState({categories: response});
            }) 
    }
    render() {
        return (
            <div>
                <select value={this.props.attributes.category} onChange={(e)=>{ this.props.setAttributes({ category: e.target.value }) }}>
                    <option value=""></option>
                   {this.state.categories.map(i => <option value={i.id}>{i.name}</option>)}
                </select>
            </div>
        )
    }
}


module.exports = {
    title: __('Carrieres', 'prograin'),
    icon: 'id-alt',
    category: 'layout',
    attributes: {
        category: {
            type: 'string',
            default: ""
        }, 
    },
    edit({ className, attributes, setAttributes }) {
        return (
            <div>
                <Choix attributes={attributes} setAttributes={setAttributes} />
            </div>
        )
    },
    save({ attributes }) {
        return (
            <div>
                {"[carriere type=\""+attributes.category+"\"]"}
            </div>
        )
    }
}