const allElements = Object.assign({}, wp.i18n, wp.blocks, wp.editor, wp.element, wp.components)
const {
    Fragment,
    Component, 
    PanelBody,
    RangeControl, 
    Toolbar,
    IconButton,   
    Button, 
    SelectControl, 
    TextControl,
    InnerBlocks,

    BlockControls,
    InspectorControls,
    __ 
} = allElements; 


const generateTemplate = function (count) {
    let template = []
    for (var i = 0; i < count; i++) {
        template.push(['balise/section-block-col'])
    }
    return template
}
const generateStyle = function (attributes) {
    let style = {};
    if (attributes.backgroundColor) {
        style.backgroundColor = attributes.backgroundColor;
    }
    if (attributes.textColor) {
        style.color = attributes.textColor;
    }
    if (attributes.backgroundImage) {
        style.backgroundImage = `url(${
            attributes.backgroundImage.sizes.full.url
            })`;
    }
    if (attributes.paddingBottom) {
        style.paddingBottom = attributes.paddingBottom;
    }

    return style;
}


class BackgroundPreview extends Component {
    constructor(props) {
        super(props)
        this.state = {
            mode: this.props.mode || "pattern"
        }
    }
    componentDidMount() {
        const props = this.props
        let clicked = false;
        this.refs.container.addEventListener('mousedown', (e) => {
            clicked = true;
        })
        window.addEventListener('mouseup', (e) => {
            clicked = false;
        })
        window.addEventListener('mousemove', (e) => {
            if (clicked && props.onChange && this.state.mode !== "pattern") {
                var rect = this.refs.container.getBoundingClientRect();
                var x = Math.round(e.clientX - rect.left); //x position within the element.
                var y = Math.round(e.clientY - rect.top); //y position within the element.
                x = (x <= rect.width) ? x : rect.width;
                y = (y <= rect.height) ? y : rect.height;
                x = (x >= 0) ? x : 0;
                y = (y >= 0) ? y : 0;
                props.onChange((x * 100) / rect.width, (y * 100) / rect.height);
            }
        })
    }
    componentDidUpdate(prevProps) {
        if (prevProps.mode !== this.props.mode) {
            this.setState({
                mode: this.props.state
            })
        }
    }
    render() {
        const props = this.props
        let left = 50;
        let top = 50;
        if (props.mode !== "pattern") {
            left = typeof props.left === "number" ? props.left : 50;
            top = typeof props.top === "number" ? props.top : 50;
        }
        return (
            <div
                style={{
                    boxShadow: "0 0 10px rgba(0,0,0,0.3)",
                    marginBottom: "10px",
                    paddingBottom: "100%",
                    position: "relative",
                    overflow: "hidden"
                }}
                ref="container"
            >
                <div
                    style={{
                        position: "absolute",
                        top: -top / 5 + "%",
                        left: -left / 5 + "%",
                        width: "120%",
                        height: "120%",
                        backgroundImage: `url(${props.image})`,
                        backgroundSize: props.mode === "fill" ? "cover" : (props.mode === "contained" || props.mode === "centered" ? "contain" : (props.mode === "custom" ? props.size : "")),
                        cursor: props.mode === "fill" ? "pointer" : "",
                        backgroundRepeat: (props.mode === "pattern" ? "repeat" : "no-repeat"),
                        backgroundPosition: props.mode !== "pattern" ? `${left}% ${top}%` : ""
                    }}
                />
            </div>
        );
    }
};



module.exports = {
    column: {
        title: __('Column'),
        icon: 'layout',
        category: 'layout',
        parent: ['balise/section-block'],

        attributes: {
            textColor: {
                type: 'color',
            },
            
            backgroundImage: {
                type: 'image',
            },
        
            paddingBottom: {
                type: 'number',
                default: 60
            },
        },
        save({ attributes }) {
            const style = generateStyle(attributes);
            return (
                <Fragment>
                    <div style={style}>
                        <div className="inside" style={{ margin: "0 auto", maxWidth: attributes.contentWidth }}>
                            <InnerBlocks.Content />
                        </div>
                    </div>
                </Fragment>
            )
        }
    },
    row: {
        title: __("Section Block"),
        icon: 'layout',
        category: 'layout',
        supports: {
            align: ['full', 'wide'],

            inserter: true,
        },
        attributes: {
            columnsCount: {
                type: 'number',
                default: 1,
            },
        },
        save({ attributes }) {
            let style = {};  
            return (
                <div className={`_sectionblock has-${attributes.columnsCount}-columns`}>

                    <InnerBlocks.Content />

                </div>      
            )
        } 
    }
}