const allElements = Object.assign({}, wp.i18n, wp.blocks, wp.editor, wp.element, wp.components)
const {
    Fragment,
    Component, 
    PanelBody,
    RangeControl, 
    Toolbar,
    IconButton,   
    Button,  
    SelectControl,
    TextControl,
    InnerBlocks,

    BlockControls,
    InspectorControls,
    __  
} = allElements; 


const generateTemplate = function (count) {
    let template = []
    for (var i = 0; i < count; i++) {
        template.push(['balise/section-block-col'])
    }
    return template
}
const generateStyle = function (attributes) {
    let style = {};
    if (attributes.backgroundColor) {
        style.backgroundColor = attributes.backgroundColor;
    }
    if (attributes.textColor) {
        style.color = attributes.textColor;
    }
    if (attributes.backgroundImage) {
        style.backgroundImage = `url(${
            attributes.backgroundImage.sizes.full.url
            })`;
    }
    if (attributes.paddingTop) {
        style.paddingTop = attributes.paddingTop;
    }
    if (attributes.paddingBottom) {
        style.paddingBottom = attributes.paddingBottom;
    }
    return style;
}



module.exports = {
    column: {
        title: __('Column'),
        icon: 'layout',
        category: 'layout',
        parent: ['balise/section-block'],

            attributes: { 
                textColor: { 
                    type: 'color', 
                }, 
                backgroundColor: { 
                    type: 'color', 
                }, 
                backgroundImage: { 
                    type: 'image', 
                }, 
                paddingTop: {
                    type: 'number',
                    default: 60
                },
                paddingBottom: {
                    type: 'number',
                    default: 60
                },
            },
        save({ attributes }) {
            const style = generateStyle(attributes);
            return (
                <Fragment>
                    <div style={style}>
                        <InnerBlocks.Content />
                    </div>
                </Fragment>
            )
        }
    },
    row: {
        title: __("Section Block"),
        icon: 'layout',
        category: 'layout',
        supports: {
            align: ['full', 'wide'],

            inserter: true,
        },
        attributes: {
            columnsCount: {
                type: 'number',
                default: 1,
            },
        },
        save({ attributes }) {
            let style = {};  
            return (
                <div className={`_sectionblock has-${attributes.columnsCount}-columns`}>

                    <InnerBlocks.Content />

                </div>      
            )
        } 
    }
}