const allElements = Object.assign({}, wp.i18n, wp.blocks, wp.editor, wp.element, wp.components)
const {
    Fragment,
    Component,
    PanelBody,
    RangeControl,
    Toolbar,
    IconButton,
    Button,
    SelectControl,
    TextControl,
    InnerBlocks,
    BlockControls,
    MediaUpload,
    InspectorControls,
    PanelColorSettings,
    __
} = allElements;

const ALLOWED_MEDIA_TYPES = ['image'];

const generateTemplate = function (count) {
    let template = []
    for (var i = 0; i < count; i++) {
        template.push(['balise/section-block-col'])
    }
    return template
}
const generateStyle = function (attributes) {
    let style = {};
    if (attributes.backgroundColor) {
        style.backgroundColor = attributes.backgroundColor;
    }
    if (attributes.textColor) {
        style.color = attributes.textColor;
    }
    if (attributes.backgroundImage) {
        style.backgroundImage = `url(${
            attributes.backgroundImage.sizes.full.url
            })`;
    }
    if (attributes.backgroundMode === "fill") {
        style.backgroundSize = "cover";
        if (typeof attributes.backgroundLeft === "number" && typeof attributes.backgroundTop === "number") {
            style.backgroundPosition = `${attributes.backgroundLeft}% ${attributes.backgroundTop}%`;
        }
    }
    if (attributes.backgroundMode === "contained") {
        style.backgroundSize = "contain";
        style.backgroundRepeat = "no-repeat";
        if (typeof attributes.backgroundLeft === "number" && typeof attributes.backgroundTop === "number") {
            style.backgroundPosition = `${attributes.backgroundLeft}% ${attributes.backgroundTop}%`;
        }
    }
    if (attributes.backgroundMode === "custom") {
        style.backgroundSize = attributes.backgroundSize;
        style.backgroundRepeat = "no-repeat";
        if (typeof attributes.backgroundLeft === "number" && typeof attributes.backgroundTop === "number") {
            style.backgroundPosition = `${attributes.backgroundLeft}% ${attributes.backgroundTop}%`;
        }
    }
    if (attributes.backgroundMode === "centered") {
        style.backgroundRepeat = "no-repeat";
        style.backgroundSize = "auto";
        if (typeof attributes.backgroundLeft === "number" && typeof attributes.backgroundTop === "number") {
            style.backgroundPosition = `${attributes.backgroundLeft}% ${attributes.backgroundTop}%`;
        }
    }
    if (attributes.paddingTop) {
        style.paddingTop = attributes.paddingTop;
    }
    if (attributes.paddingBottom) {
        style.paddingBottom = attributes.paddingBottom;
    }
    if (attributes.paddingLeft) {
        style.paddingLeft = attributes.paddingLeft;
    }
    if (attributes.paddingRight) {
        style.paddingRight = attributes.paddingRight;
    }

    return style;
}

const generateStyle2 = function(attributes) {
    let style = {};
    if (attributes.backgroundImageVertical) {
      style.backgroundImage = `url(${
        attributes.backgroundImageVertical.sizes.full.url
      })`;
    }
    if (attributes.backgroundMode === "fill") {
      style.backgroundSize = "cover";
      if (attributes.backgroundLeftVertical && attributes.backgroundTopVertical) {
        style.backgroundPosition = `${attributes.backgroundLeftVertical}% ${
          attributes.backgroundTopVertical
        }%`;
      }
    }
  
    return style;
  };

  let BackgroundPreview = function(props) {
    let left = props.left || 50;
    let top = props.top || 50;
  
    return (
      <div
        style={{
          marginBottom: "10px",
          paddingBottom: "100%",
          position: "relative",
          overflow: "hidden"
        }} 
        onClick={e => {
          if (props.onChange && props.mode === "fill") {
            var rect = e.currentTarget.getBoundingClientRect();
            var x = e.clientX - rect.left; //x position within the element.
            var y = e.clientY - rect.top; //y position within the element.
            props.onChange((x * 100) / rect.width, (y * 100) / rect.height);
          } 
        }}
      >
        <div
          style={{
            position: "absolute",
            top: -top / 5 + "%",
            left: -left / 5 + "%",
            width: "120%",
            height: "120%",
            backgroundImage: `url(${props.image})`,
            backgroundSize: props.mode === "fill" ? "cover" : "",
            cursor: props.mode === "fill" ? "pointer" : "",
            backgroundPosition: props.mode === "fill" ? `${left}% ${top}%` : ""
          }}
        />
      </div>
    );
  };
  
  const parseStyle = function(style) {};



module.exports = {
    column: {
        title: __('Column'),
        icon: 'layout',
        category: 'layout',
        parent: ['balise/section-block'],
        attributes: {
            textColor: {
                type: 'color',
            },
            backgroundColor: {
                type: 'color',
            },
            backgroundImage: {
                type: 'image',
            },
            backgroundMode: {
                type: "string",
                default: "fill"
            },
            backgroundSize: {
                type: "string",
            },
            backgroundLeft: {
                type: "number"
            },
            contentWidth: {
                type: "string",
            },
            contentMargin: {
                type: "string",
            },
            backgroundTop: {
                type: "number"
            },
            paddingTop: {
                type: 'number',
                default: 60
            },
            paddingBottom: {
                type: 'number',
                default: 60
            },
            paddingLeft: {
                type: 'number',
                default: 10
            },
            paddingRight: {
                type: 'number',
                default: 10
            },

            backgroundImageVertical: {
                type: "image"
            },
            backgroundLeftVertical: {
                type: "number"
            },

            backgroundTopVertical: {
                type: "number"
            },
            vimeo: {
                type: "string",
            },
        },
        edit({ className, attributes, setAttributes }) {
            console.log(attributes);
            const setTextColor = (textColor) => { setAttributes({ textColor }); }
            const setBackgroundColor = (backgroundColor) => { setAttributes({ backgroundColor }); }
            const onSelectImage = (backgroundImage) => {
                if (!backgroundImage) {
                    setAttributes({ backgroundImage: { url: undefined, alt: undefined, id: undefined, caption: undefined } })
                } else {
                    setAttributes({ backgroundImage })
                }
            }

            const onSelectImageVertical = backgroundImageVertical => {
                if (!backgroundImageVertical) {
                    setAttributes({
                        backgroundImageVertical: {
                            url: undefined,
                            alt: undefined,
                            id: undefined,
                            caption: undefined
                        }
                    });
                } else {
                    setAttributes({ backgroundImageVertical });
                }
            };
            const setBackgroundSize = (backgroundSize) => { setAttributes({ backgroundSize }); }
            const setPaddingTop = (paddingTop) => { setAttributes({ paddingTop }); }
            const setPaddingBottom = (paddingBottom) => { setAttributes({ paddingBottom }); }
            const setPaddingLeft = (paddingLeft) => { setAttributes({ paddingLeft }); }
            const setPaddingRight = (paddingRight) => { setAttributes({ paddingRight }); }
            const setContentWidth = (contentWidth) => { setAttributes({ contentWidth }); }

            const setContentMargin = (contentMargin) => { setAttributes({ contentMargin }); }

            const setVimeo = vimeo => {
                setAttributes({ vimeo });
              };
            const style = generateStyle(attributes);
            return (
                <Fragment>
                    <BlockControls>
                        <Toolbar>
                            <MediaUpload
                                onSelect={onSelectImage}
                                allowedTypes={ALLOWED_MEDIA_TYPES}
                                value={attributes.backgroundImage && attributes.backgroundImage.id}
                                render={({ open }) => (
                                    <IconButton
                                        label={__('Edit image')}
                                        icon="format-image"
                                        onClick={open}
                                    />
                                )}
                            />
                        </Toolbar>
                    </BlockControls>
                    <InspectorControls>
                        <PanelBody title="Image de fond">
                            <SelectControl
                                label="Type"
                                value={attributes.backgroundMode}
                                onChange={value => {
                                    setAttributes({ backgroundMode: value });
                                }}
                                options={[
                                    { label: "Mosaique", value: "pattern" },
                                    { label: "Fill", value: "fill" },
                                    { label: "Contained", value: "contained" },
                                    { label: "Centered", value: "centered" },
                                    { label: "Custom", value: "custom" }
                                ]}
                            />
                            {attributes.backgroundMode === "custom" && <TextControl
                                label="Background Size"
                                placeholder="100% auto, 200px 100px, etc."
                                value={attributes.url}
                                onChange={setBackgroundSize}
                            />}
                            <p>
                                {attributes.backgroundImage && attributes.backgroundImage.id && (
                                    <BackgroundPreview
                                        mode={attributes.backgroundMode}
                                        left={attributes.backgroundLeft}
                                        top={attributes.backgroundTop}
                                        image={attributes.backgroundImage.sizes.full.url}
                                        onChange={(left, top) => {
                                            setAttributes({
                                                backgroundLeft: left,
                                                backgroundTop: top
                                            });
                                        }}
                                    />
                                )}

                                <MediaUpload
                                    onSelect={onSelectImage}
                                    allowedTypes={ALLOWED_MEDIA_TYPES}
                                    value={
                                        attributes.backgroundImage && attributes.backgroundImage.id
                                    }
                                    render={({ open }) => (
                                        <Button isDefault onClick={open}>
                                            {attributes.backgroundImage
                                                ? "Change image"
                                                : "Add a horizontal background"}
                                        </Button>
                                    )}
                                />
                                {attributes.backgroundImage &&
                                <Button isDefault onClick={() => { setAttributes({ backgroundImage: null }) }}>
                                    Remove Image
                                    </Button>}
                            </p>
                            <p>

                                {attributes.backgroundImageVertical && attributes.backgroundImageVertical.id && (
                                    <BackgroundPreview
                                        mode={attributes.backgroundMode}
                                        left={attributes.backgroundLeftVertical}
                                        top={attributes.backgroundTopVertical}
                                        image={attributes.backgroundImageVertical.sizes.full.url}
                                        onChange={(left, top) => {
                                            setAttributes({
                                                backgroundLeftVertical: left,
                                                backgroundTopVertical: top
                                            });
                                        }}
                                    />
                                )}
                                <MediaUpload
                                    onSelect={onSelectImageVertical}
                                    allowedTypes={ALLOWED_MEDIA_TYPES}
                                    value={
                                        attributes.backgroundImageVertical && attributes.backgroundImageVertical.id
                                    }
                                    render={({ open }) => (
                                        <Button isDefault onClick={open}>
                                            {attributes.backgroundImageVertical
                                                ? "Change vertical image"
                                                : "Add a vertical background"}
                                        </Button>
                                    )}
                                />
                               {attributes.backgroundImageVertical &&
                <Button isDefault onClick={() => { setAttributes({ backgroundImageVertical: null }) }}>
                    Remove Image
                    </Button>}
                            </p>

                            <TextControl
                                placeholder="Vimeo ID"
                                value={attributes.vimeo}
                                onChange={setVimeo}
                            />

                        </PanelBody>
                        <PanelColorSettings
                            title={__('Color Settings')}
                            initialOpen={true}
                            colorSettings={[
                                {
                                    value: attributes.backgroundColor,
                                    onChange: setBackgroundColor,
                                    label: __('Background Color'),
                                },
                                {
                                    value: attributes.textColor,
                                    onChange: setTextColor,
                                    label: __('Text Color'),
                                },
                            ]}
                        />
                        <PanelBody title={__('Padding')}>
                            <RangeControl
                                label={__('Top')}
                                value={attributes.paddingTop}
                                onChange={setPaddingTop}
                                min={0}
                                max={400}
                            />
                            <RangeControl
                                label={__('Bottom')}
                                value={attributes.paddingBottom}
                                onChange={setPaddingBottom}
                                min={0}
                                max={400}
                            />
                            <RangeControl
                                label={__('Left')}
                                value={attributes.paddingLeft}
                                onChange={setPaddingLeft}
                                min={0}
                                max={400}
                            />
                            <RangeControl
                                label={__('Right')}
                                value={attributes.paddingRight}
                                onChange={setPaddingRight}
                                min={0}
                                max={400}
                            />
                        </PanelBody><PanelBody title="Content">
                            <TextControl
                                label="Max content width"
                                placeholder="90%, 768px, etc."
                                value={attributes.contentWidth}
                                onChange={setContentWidth}
                            />
                            <TextControl
                                label="Content margin"
                                placeholder="all; T R B L; T/B L/R; T L/R B"
                                value={attributes.contentMargin}
                                onChange={setContentMargin}
                            />
                        </PanelBody>


                    </InspectorControls>

                    <div className="_sectionblock-slide " style={{
                        color: attributes.textColor,
                        paddingTop: attributes.paddingTop,
                        paddingBottom: attributes.paddingBottom,
                        paddingLeft: attributes.paddingLeft,
                        paddingRight: attributes.paddingRight
                    }}>
                        <div className="_background" style={style}></div>
                        <div className="inside" style={{ margin: attributes.contentMargin || "0 auto", maxWidth: attributes.contentWidth }}>
                            <InnerBlocks
                                templateLock={false} />
                        </div>
                    </div>
                </Fragment>
            );
        },
        save({ attributes }) {
            const style = generateStyle(attributes);
            const style2 = generateStyle2(attributes);
            
            return (
                <Fragment>
                    <div className={(attributes.backgroundImageVertical && " verticalbg" || "")} style={style}>
            <div className="verticalbg" style={style2}></div>
            {attributes.vimeo && 
            <iframe className="videobg" src={ "https://player.vimeo.com/video/"+attributes.vimeo+"?background=1&autoplay=1&byline=0&title=0&muted=1" }
           frameborder="0" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>
          }
                        <div className="inside" style={{ margin: attributes.contentMargin || "0 auto", maxWidth: attributes.contentWidth }}>
                            <InnerBlocks.Content />
                        </div>
                    </div>
                </Fragment>
            )
        }
    },
    row: {
        title: __("Section Block"),
        icon: 'layout',
        category: 'layout',
        supports: {
            align: ['full', 'wide'],

            inserter: true,
        },
        attributes: {
            columnsCount: {
                type: 'number',
                default: 1,
            },
        },
        edit({ className, attributes, setAttributes }) {
            const classes = `_sectionblock has-${attributes.columnsCount}-columns`;

            const ajustColumns = (newColumnCount) => {
                setAttributes({
                    columnsCount: newColumnCount,
                });
            }
            const onSelectImage = (backgroundImage) => {
                if (!backgroundImage) {
                    setAttributes({ backgroundImage: { url: undefined, alt: undefined, id: undefined, caption: undefined } })
                } else {
                    setAttributes({ backgroundImage })
                }
            }

            let style = {};
            return (
                <Fragment>
                    <InspectorControls>
                        <PanelBody title={__('Columns')}>
                            <RangeControl
                                label={__('Columns')}
                                value={attributes.columnsCount}
                                onChange={ajustColumns}
                                min={1}
                                max={6}
                            />
                        </PanelBody>
                    </InspectorControls>
                    <div className={`_sectionblock has-${attributes.columnsCount}-columns`}>
                        <InnerBlocks
                            template={generateTemplate(attributes.columnsCount)}
                            allowedBlocks={['balise/section-block-col']}
                            templateLock="all" />
                    </div>
                </Fragment>
            );
        },
        save({ attributes }) {
            let style = {};
            return (
                <div className={`_sectionblock has-${attributes.columnsCount}-columns`}>

                    <InnerBlocks.Content />

                </div>
            )
        }
    }
}