const allElements = Object.assign({}, wp.i18n, wp.blocks, wp.editor, wp.element, wp.components)
const {
    Component,
    __
} = allElements;

class SemencesList extends Component {
    constructor(props) {
        super(props)
        this.state = {
            semences: []
        }
        this.update = this.update.bind(this)
    }
    componentDidMount() {
        this.update()
    }
    componentDidupdate(prevProps) {
        if (this.props.category !== prevProps.category) {
        this.update()
    }
    }
    update () {
        wp.apiFetch({
            path: '/wp/v2/semence-prograin/'
            })
            .then((response) => {
                this.setState({ semences: response });
            })
    }
    render() {
        return ( 
            <div>
                {this.state.semences.map(post => (
                    <div class="semence-archive-item">

                        <div class="col1">
                            <h2>{post.title.rendered}</h2>
                            <div className="semence-archive">
                                <div class="semence-bigdata">
                                    <small>    {__('UTM', 'prograin')}</small>
                                    <div class="data">{post.utm}</div>
                                </div>

                                <div class="semence-bigdata">
                                    <small>    {__('MR', 'prograin')}</small>
                                    <div class="data">{post.mr}</div>
                                </div>
                            </div>

                        </div>
                    </div>
                ))}
            </div>
        )
    }
}


module.exports = {
    title: __('Liste de semances', 'prograin'),
    icon: <svg xmlns="http://www.w3.org/2000/svg" data-name="Layer 1" viewBox="0 0 24 24" x="0px" y="0px"><title>Food</title><path d="M22.269,8.826A5.073,5.073,0,0,0,19.245,5.36a3.146,3.146,0,0,0-3.054.605,8.382,8.382,0,0,0-1.976,2.646,8.035,8.035,0,0,1-1.351,1.929,10.982,10.982,0,0,0-1.872-1.334,6.747,6.747,0,0,1-2.25-1.85,6.087,6.087,0,0,1-.522-1.1c-.087-.219-.175-.437-.273-.652A3.428,3.428,0,0,0,4.475,3.568,3.228,3.228,0,0,0,1.637,6.15,8.083,8.083,0,0,0,2.92,12.3a9.377,9.377,0,0,0,4.423,3.179A3.988,3.988,0,0,0,7.467,16.7a5.081,5.081,0,0,0,3.111,3.376,6.3,6.3,0,0,0,2.182.375A7.765,7.765,0,0,0,14.7,20.2a11.073,11.073,0,0,0,7.162-6.177A7.96,7.96,0,0,0,22.269,8.826ZM8.311,13.156a4.044,4.044,0,0,0-.7,1.14A8.138,8.138,0,0,1,3.883,11.58,6.878,6.878,0,0,1,2.805,6.426,2.032,2.032,0,0,1,4.6,4.763,2.235,2.235,0,0,1,6.856,6.108c.089.2.169.395.249.595A7.1,7.1,0,0,0,7.74,8.019a7.738,7.738,0,0,0,2.625,2.212,11.946,11.946,0,0,1,1.464,1c-.068.032-.138.064-.212.1-.242.1-.488.2-.734.291A5.872,5.872,0,0,0,8.311,13.156Zm12.447.392A9.83,9.83,0,0,1,14.4,19.033a5.794,5.794,0,0,1-3.406-.085A3.847,3.847,0,0,1,8.629,16.4a2.719,2.719,0,0,1-.039-1.228v-.006a2.694,2.694,0,0,1,.626-1.223,4.879,4.879,0,0,1,2.092-1.209c.263-.1.526-.2.784-.312a6.009,6.009,0,0,0,1.043-.561l.022-.016.046-.033a7.59,7.59,0,0,0,2.082-2.659,7.345,7.345,0,0,1,1.647-2.247A1.983,1.983,0,0,1,18.87,6.5a3.892,3.892,0,0,1,2.24,2.643A6.851,6.851,0,0,1,20.758,13.548ZM17.021,10.38a6.658,6.658,0,0,1-3.639,3.776.6.6,0,1,1-.468-1.105,5.452,5.452,0,0,0,2.986-3.1.6.6,0,0,1,1.121.428Zm-7.673.771a.6.6,0,0,1-.575.429.621.621,0,0,1-.172-.025A4.677,4.677,0,0,1,5.376,8.112a.6.6,0,0,1,1.17-.268,3.473,3.473,0,0,0,2.4,2.559A.6.6,0,0,1,9.349,11.15Z"></path></svg>,
    category: 'layout',
    attributes: {

        category: {
            type: 'string',
            default: ""
        }, 

    },
    edit({ className, attributes, setAttributes }) {

        return (
            <div>
                <select value={attributes.category} onChange={(e) => { setAttributes({ category: e.target.value }) }}>
                    <option value="">Toutes</option>
                    <option value="ogm">OGM</option>
                    <option value="noogm">Sans ogm</option>
                    <option value="nonbio">Sans ogm / Non-Biologique</option>
                    <option value="bio">Sans ogm / Biologique</option>
                </select>
                <SemencesList category={attributes.category} />
            </div>
        )   
    },
    save({ attributes }) {
        return (
            <div>
                {"[semenceslist " + (attributes.category || "") + "]"}
            </div>
        )
    }
}