const allElements = Object.assign({}, wp.i18n, wp.blocks, wp.editor, wp.element, wp.components)
const {
    Component,
    __
} = allElements;

class SoyaList extends Component {
    constructor(props) {
        super(props)
        this.state = {
            semences: []
        }
    }
    componentDidMount() {
        fetch('/wp-json/wp/v2/semence-prograin')
        .then((resp) => resp.json())
            .then((response) => {
               this.setState({semences: response});
            }) 
    }
    render() {
        return (
            <div>
                {this.state.semences.map(post => (
                    <div class="semence-archive-item">
                        <div class="col1"> 
                            <h2>{post.title.rendered}</h2>
                            <div className="semence-archive">
                                    <div class="semence-bigdata">
                                        <small>    {__('UTM', 'prograin')}</small>
                                        <div class="data">{post.utm}</div>
                                    </div>

                                    <div class="semence-bigdata">
                                        <small>    {__('MR', 'prograin')}</small>
                                        <div class="data">{post.mr}</div>
                                    </div>
                                </div>

                        </div>
                    </div>
                ))}
            </div>
        )
    }
}


module.exports = {
    title: __('Liste de soya', 'prograin'),
    icon: {
        src: <svg xmlns="http://www.w3.org/2000/svg" data-name="Layer 1" viewBox="0 0 128 128" x="0px" y="0px"><title>Artboard 16</title><path d="M104.61,25.18l.09-.07a12.73,12.73,0,0,0,1.83-2,16.34,16.34,0,0,0,2.41-4.82,18.19,18.19,0,0,0,.58-2.61c.05-.44.13-.88.16-1.32a10.19,10.19,0,0,0,0-1.32,7,7,0,0,0-2.56-4.9,2.76,2.76,0,0,0-3.74.25l-.23.24a8.47,8.47,0,0,0-1.48,2.17A8.35,8.35,0,0,0,101,12.7c-.21,1.24-.25,2.45-.39,3.67s-.31,2.42-.51,3.68c-.09.63-.2,1.27-.32,1.92l-.17,1c0,.18-.07.38-.09.56-9.07-.46-19.52,10-24.07,14.54a21.78,21.78,0,0,0-6.22,12.47,10.86,10.86,0,0,1-6.64,8.31A22,22,0,0,0,50.93,70.45a10.86,10.86,0,0,1-8.31,6.64,21.79,21.79,0,0,0-12.47,6.22c-5.8,5.8-21.21,21.21-11.31,31.11,4.26,4.26,12.74,6.39,21.21,6.39s17-2.13,21.21-6.39a21.87,21.87,0,0,0,4-5.54,15.29,15.29,0,0,1,10.37-8.28,22,22,0,0,0,17-17A15.29,15.29,0,0,1,101,73.21a21.87,21.87,0,0,0,5.54-4c8.53-8.52,8.53-33.9,0-42.43A12,12,0,0,0,104.61,25.18ZM52.79,105.94a10,10,0,1,1,0-14.14A10,10,0,0,1,52.79,105.94ZM101,53.62A10,10,0,1,1,98,46.54,9.94,9.94,0,0,1,101,53.62ZM78.24,86.14a10,10,0,1,1,0-14.14A10,10,0,0,1,78.24,86.14Z"></path></svg>
    },
    category: 'prograin',
    attributes: {
        category: {
            type: 'string',
            default: ""
        }, 
    },
    edit({ className, attributes, setAttributes }) {

        return (
            <div>
                <SoyaList />
            </div>
        )
    },
    save({ attributes }) {
        return (
            <div>
                {"[soyalist]"}
            </div>
        )
    }
}