const allElements = Object.assign({}, wp.i18n, wp.blocks, wp.editor, wp.element, wp.components)
const {
    Component,
    __
} = allElements;

class GenerateShortCode extends Component {
    constructor(props) {
        super(props)
        this.state = {
            html: ""
        }
    }
    componentDidMount() { 
       let url = new URL(window.currentSite)
       url.searchParams.append('generateshortcode',this.props.data)
        fetch(url) 
        .then((resp) => resp.text())
        .then((response) => {
                this.setState({html: response });
            })
    }
    render() {
        return ( 
            <div dangerouslySetInnerHTML={{ __html: this.state.html }}>
            </div>
        )
    }  
} 
/*


*/

module.exports = { 
    title: __('Équipe', 'prograin'),
    icon: 'groups',
    category: 'layout',  
    attributes: {  

    },
    edit({ className, attributes, setAttributes }) {
        return (
            <div>
                <GenerateShortCode data={"[team]"} />
            </div>
        )
    },
    save({ attributes }) {
        return (
            <div>
                {"[team]"}
            </div>
        )
    }
}