<?php
// LOAD COMPOSER AUTO LOADER
include('includes/composer_modules/autoload.php'); 
Balise\AnchorFramework\Anchor::Init();

// LOAD EVERYTHING IN CONTENT FOLDER

add_action( 'init', function() {
    $files=glob(__DIR__."/app/content/*/*.php");
foreach ($files as $file) { 
    require_once($file);
} 
} );

// STYLES AND SCRIPTS
add_action( 'wp_enqueue_scripts', function(){
    if (!is_admin()) {
        wp_enqueue_style('main-style',  get_stylesheet_directory_uri().'/public/css/style.css', array(), '0de8e396e9305eddc3dc31b9e10e3e8e', 'all');
        wp_enqueue_style('mxo-style',  get_stylesheet_directory_uri().'/public/css/mxo.css', array(), '2de8e396e9305eddc3dc31b9e10e3e8e', 'all');
        wp_enqueue_script('main-script',  get_stylesheet_directory_uri().'/public/js/script.js', array('wp-i18n'), 'f4a8cc2e6fff2f7f1c316be2a8a30725', true);
    }  
},1);

// LOAD ADMIN STYLES AND SCRIPTS
add_action( 'admin_enqueue_scripts', function () {
    if (is_admin() && file_exists(__DIR__ . '/public/editor/admin.css')) {
    wp_enqueue_style('main-style', get_stylesheet_directory_uri() . '/public/editor/admin.css', array(), 'd3ad5274c13ae95ac277581b20b18982', 'all');
}
},1);

// LOAD SCRIPT AND STYLE FOR GUTENBERG EDITOR
add_action('enqueue_block_editor_assets', function(){
    wp_enqueue_script('components',  get_stylesheet_directory_uri().'/public/editor/components.js', array(), '1');
},1);

// FILES IN INCLUDE PATH
include("app/includes/GenerateShortCode.php");
include("app/includes/PolyLangSlug.php");
include("app/includes/carrieres-liste.php");
include("app/includes/cleanbackend.php");
include("app/includes/display_data.fct.php");
include("app/includes/editor.php");
include("app/includes/emploi-meta.php");
include("app/includes/fill-distributeurs.php");
include("app/includes/french_punctuations.php");
include("app/includes/google-admin-font.php");
include("app/includes/googlemap.php");
include("app/includes/gutenberg.php");
include("app/includes/hideEmail.php");
include("app/includes/hr_role.php");
include("app/includes/i18n.php");
include("app/includes/langtoggle_menu.php");
include("app/includes/models.php");
include("app/includes/optionPage.php");
include("app/includes/options.php");
include("app/includes/pageByTemplate.php");
include("app/includes/remove_admin_bar.php");
include("app/includes/semences-list.php");
include("app/includes/soya-liste.php");
include("app/includes/syncfields.php");
include("app/includes/team-list.php");
include("app/includes/theme_support.php");
include("app/includes/title_short_tag.php");
